/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql;

import jakarta.nosql.ServiceLoaderProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface Settings {
    public Set<String> keySet();

    public Map<String, Object> toMap();

    public Optional<Object> get(String var1);

    public Optional<Object> get(Collection<String> var1);

    public List<Object> prefix(String var1);

    public List<Object> prefix(Collection<String> var1);

    public <T> Optional<T> get(String var1, Class<T> var2);

    public Object getOrDefault(String var1, Object var2);

    public boolean isEmpty();

    public int size();

    public boolean containsKey(String var1);

    public Set<Map.Entry<String, Object>> entrySet();

    public void forEach(BiConsumer<String, Object> var1);

    public void computeIfPresent(String var1, BiConsumer<String, Object> var2);

    public void computeIfAbsent(String var1, Function<String, Object> var2);

    public static SettingsBuilder builder() {
        return (SettingsBuilder)ServiceLoaderProvider.get(SettingsBuilderProvider.class).get();
    }

    public static Settings of(Map<String, Object> settings) {
        Objects.requireNonNull(settings, "settings is required");
        SettingsBuilder builder = Settings.builder();
        builder.putAll(settings);
        return builder.build();
    }

    @SafeVarargs
    public static Settings of(Map<String, Object> ... settings) {
        Stream.of(settings).forEach((? super T s) -> Objects.requireNonNull(s, "Settings is required"));
        SettingsBuilder builder = Settings.builder();
        Stream.of(settings).forEach(builder::putAll);
        return builder.build();
    }

    public static interface SettingsBuilderProvider
    extends Supplier<SettingsBuilder> {
    }

    public static interface SettingsBuilder {
        public SettingsBuilder put(String var1, Object var2);

        public SettingsBuilder putAll(Map<String, Object> var1);

        public Settings build();
    }
}

