/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Priority;

final class ServiceLoaderSort<T>
implements Comparable<ServiceLoaderSort<T>>,
Supplier<T> {
    private final int priority;
    private final T instance;

    private ServiceLoaderSort(int priority, T instance) {
        this.priority = priority;
        this.instance = instance;
    }

    @Override
    public T get() {
        return this.instance;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(ServiceLoaderSort<T> other) {
        return Integer.compare(other.priority, this.priority);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLoaderSort that = (ServiceLoaderSort)o;
        return this.priority == that.priority;
    }

    public int hashCode() {
        return Objects.hashCode(this.priority);
    }

    static <T> ServiceLoaderSort of(T instance) {
        int priority = Optional.ofNullable(instance.getClass().getAnnotation(Priority.class)).map(Priority::value).orElse(0);
        return new ServiceLoaderSort<T>(priority, instance);
    }
}

