/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.column;

import jakarta.nosql.Condition;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.column.Column;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;

public interface ColumnCondition {
    public Column getColumn();

    public Condition getCondition();

    public ColumnCondition and(ColumnCondition var1);

    public ColumnCondition negate();

    public ColumnCondition or(ColumnCondition var1);

    public static ColumnCondition eq(Column column) {
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(column, Condition.EQUALS);
    }

    public static ColumnCondition eq(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(Column.of(name, value), Condition.EQUALS);
    }

    public static ColumnCondition gt(Column column) {
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(column, Condition.GREATER_THAN);
    }

    public static ColumnCondition gt(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(Column.of(name, value), Condition.GREATER_THAN);
    }

    public static ColumnCondition gte(Column column) {
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(column, Condition.GREATER_EQUALS_THAN);
    }

    public static ColumnCondition gte(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(Column.of(name, value), Condition.GREATER_EQUALS_THAN);
    }

    public static ColumnCondition lt(Column column) {
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(column, Condition.LESSER_THAN);
    }

    public static ColumnCondition lt(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(Column.of(name, value), Condition.LESSER_THAN);
    }

    public static ColumnCondition lte(Column column) {
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(column, Condition.LESSER_EQUALS_THAN);
    }

    public static ColumnCondition lte(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(Column.of(name, value), Condition.LESSER_EQUALS_THAN);
    }

    public static ColumnCondition in(Column column) {
        return ((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).in(column);
    }

    public static ColumnCondition in(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return ((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).in(Column.of(name, value));
    }

    public static ColumnCondition like(Column column) {
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(column, Condition.LIKE);
    }

    public static ColumnCondition like(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return (ColumnCondition)((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).apply(Column.of(name, value), Condition.LIKE);
    }

    public static ColumnCondition between(Column column) {
        return ((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).between(column);
    }

    public static ColumnCondition between(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return ((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).between(Column.of(name, value));
    }

    public static ColumnCondition not(ColumnCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        return condition.negate();
    }

    public static ColumnCondition and(ColumnCondition ... conditions) {
        return ((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).and(conditions);
    }

    public static ColumnCondition or(ColumnCondition ... conditions) {
        return ((ColumnConditionProvider)ServiceLoaderProvider.get(ColumnConditionProvider.class, () -> ServiceLoader.load(ColumnConditionProvider.class))).or(conditions);
    }

    public static interface ColumnConditionProvider
    extends BiFunction<Column, Condition, ColumnCondition> {
        public ColumnCondition between(Column var1);

        public ColumnCondition and(ColumnCondition ... var1);

        public ColumnCondition or(ColumnCondition ... var1);

        public ColumnCondition in(Column var1);
    }
}

