/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.column;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.column.ColumnPreparedStatement;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.column.ColumnQueryParser;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public interface ColumnFamilyManager
extends AutoCloseable {
    public ColumnEntity insert(ColumnEntity var1);

    public ColumnEntity update(ColumnEntity var1);

    public Iterable<ColumnEntity> update(Iterable<ColumnEntity> var1);

    public ColumnEntity insert(ColumnEntity var1, Duration var2);

    public Iterable<ColumnEntity> insert(Iterable<ColumnEntity> var1);

    public Iterable<ColumnEntity> insert(Iterable<ColumnEntity> var1, Duration var2);

    public void delete(ColumnDeleteQuery var1);

    public Stream<ColumnEntity> select(ColumnQuery var1);

    default public Stream<ColumnEntity> query(String query) {
        Objects.requireNonNull(query, "query is required");
        ColumnQueryParser parser = (ColumnQueryParser)ServiceLoaderProvider.get(ColumnQueryParser.class);
        return parser.query(query, this, ColumnObserverParser.EMPTY);
    }

    default public ColumnPreparedStatement prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        ColumnQueryParser parser = (ColumnQueryParser)ServiceLoaderProvider.get(ColumnQueryParser.class);
        return parser.prepare(query, this, ColumnObserverParser.EMPTY);
    }

    default public Optional<ColumnEntity> singleResult(ColumnQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream<ColumnEntity> entities = this.select(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        ColumnEntity entity = (ColumnEntity)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + query);
    }

    public long count(String var1);

    @Override
    public void close();
}

