/*
 * Decompiled with CFR 0.152.
 */
package jakarta.nosql.column;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.column.ColumnPreparedStatementAsync;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.column.ColumnQueryParserAsync;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface ColumnFamilyManagerAsync
extends AutoCloseable {
    public void insert(ColumnEntity var1);

    public void insert(ColumnEntity var1, Duration var2);

    public void insert(ColumnEntity var1, Consumer<ColumnEntity> var2);

    public void insert(Iterable<ColumnEntity> var1);

    public void insert(Iterable<ColumnEntity> var1, Duration var2);

    public void insert(ColumnEntity var1, Duration var2, Consumer<ColumnEntity> var3);

    public void update(ColumnEntity var1);

    public void update(Iterable<ColumnEntity> var1);

    public void update(ColumnEntity var1, Consumer<ColumnEntity> var2);

    public void delete(ColumnDeleteQuery var1);

    public void delete(ColumnDeleteQuery var1, Consumer<Void> var2);

    public void select(ColumnQuery var1, Consumer<Stream<ColumnEntity>> var2);

    default public void query(String query, Consumer<Stream<ColumnEntity>> callBack) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callBack, "callBack is required");
        ColumnQueryParserAsync parser = (ColumnQueryParserAsync)ServiceLoaderProvider.get(ColumnQueryParserAsync.class);
        parser.query(query, this, callBack, ColumnObserverParser.EMPTY);
    }

    default public ColumnPreparedStatementAsync prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        ColumnQueryParserAsync parser = (ColumnQueryParserAsync)ServiceLoaderProvider.get(ColumnQueryParserAsync.class);
        return parser.prepare(query, this, ColumnObserverParser.EMPTY);
    }

    default public void singleResult(ColumnQuery query, Consumer<Optional<ColumnEntity>> callBack) {
        Objects.requireNonNull(query, "query is required");
        this.select(query, entities -> {
            Iterator iterator = entities.iterator();
            if (!iterator.hasNext()) {
                callBack.accept(Optional.empty());
                return;
            }
            ColumnEntity entity = (ColumnEntity)iterator.next();
            if (!iterator.hasNext()) {
                callBack.accept(Optional.of(entity));
                return;
            }
            throw new NonUniqueResultException("The select returns more than one entity, select: " + query);
        });
    }

    public void count(String var1, Consumer<Long> var2);

    @Override
    public void close();
}

