/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.binding.types;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import jakarta.mvc.tck.tests.binding.types.BindingTypesController;
import jakarta.mvc.tck.tests.binding.types.BindingTypesLocaleResolver;
import jakarta.mvc.tck.util.Archives;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class BindingTypesTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(BindingTypesController.class).addClass(BindingTypesLocaleResolver.class).addView("binding/types/view.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_binding_annotation", id="all-binding-annotations")})
    public void bindingWithPathParam() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/binding/types/path/1,234");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value: [1.234]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_binding_annotation", id="all-binding-annotations")})
    public void bindingWithQueryParam() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/binding/types/query?value=2,34");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value: [2.34]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_binding_annotation", id="all-binding-annotations")})
    public void bindingWithHeaderParam() throws IOException {
        WebRequest request = new WebRequest(new URL(this.baseUrl.toString() + "mvc/binding/types/header"));
        request.setAdditionalHeader("X-Header-Value", "3,95");
        Page page = this.webClient.getPage(request);
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value: [3.95]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_binding_annotation", id="all-binding-annotations")})
    public void bindingWithFormParam() throws IOException {
        WebRequest request = new WebRequest(new URL(this.baseUrl.toString() + "mvc/binding/types/form"));
        request.setHttpMethod(HttpMethod.POST);
        request.setRequestParameters(Collections.singletonList(new NameValuePair("value", "6,2")));
        Page page = this.webClient.getPage(request);
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value: [6.2]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_binding_annotation", id="all-binding-annotations")})
    public void bindingWithMatrixParam() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/binding/types/matrix;value=2,11");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value: [2.11]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_binding_annotation", id="all-binding-annotations")})
    public void bindingWithCookieParam() throws IOException {
        WebRequest request = new WebRequest(new URL(this.baseUrl.toString() + "mvc/binding/types/cookie"));
        request.setAdditionalHeader("Cookie", "X-COOKIE-VALUE=1.234");
        Page page = this.webClient.getPage(request);
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value: [1234]"));
    }
}

