/*
 * Decompiled with CFR 0.152.
 */
package org.atinject.tck.auto;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import junit.framework.TestCase;
import org.atinject.tck.auto.Car;
import org.atinject.tck.auto.Drivers;
import org.atinject.tck.auto.DriversSeat;
import org.atinject.tck.auto.Engine;
import org.atinject.tck.auto.Seat;
import org.atinject.tck.auto.Tire;
import org.atinject.tck.auto.accessories.Cupholder;
import org.atinject.tck.auto.accessories.RoundThing;
import org.atinject.tck.auto.accessories.SpareTire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Convertible
implements Car {
    @Inject
    @Drivers
    Seat driversSeatA;
    @Inject
    @Drivers
    Seat driversSeatB;
    @Inject
    SpareTire spareTire;
    @Inject
    Cupholder cupholder;
    @Inject
    Provider<Engine> engineProvider;
    private boolean methodWithZeroParamsInjected;
    private boolean methodWithMultipleParamsInjected;
    private boolean methodWithNonVoidReturnInjected;
    private Seat constructorPlainSeat;
    private Seat constructorDriversSeat;
    private Tire constructorPlainTire;
    private Tire constructorSpareTire;
    private Provider<Seat> constructorPlainSeatProvider = Convertible.nullProvider();
    private Provider<Seat> constructorDriversSeatProvider = Convertible.nullProvider();
    private Provider<Tire> constructorPlainTireProvider = Convertible.nullProvider();
    private Provider<Tire> constructorSpareTireProvider = Convertible.nullProvider();
    @Inject
    Seat fieldPlainSeat;
    @Inject
    @Drivers
    Seat fieldDriversSeat;
    @Inject
    Tire fieldPlainTire;
    @Inject
    @Named(value="spare")
    Tire fieldSpareTire;
    @Inject
    Provider<Seat> fieldPlainSeatProvider = Convertible.nullProvider();
    @Inject
    @Drivers
    Provider<Seat> fieldDriversSeatProvider = Convertible.nullProvider();
    @Inject
    Provider<Tire> fieldPlainTireProvider = Convertible.nullProvider();
    @Inject
    @Named(value="spare")
    Provider<Tire> fieldSpareTireProvider = Convertible.nullProvider();
    private Seat methodPlainSeat;
    private Seat methodDriversSeat;
    private Tire methodPlainTire;
    private Tire methodSpareTire;
    private Provider<Seat> methodPlainSeatProvider = Convertible.nullProvider();
    private Provider<Seat> methodDriversSeatProvider = Convertible.nullProvider();
    private Provider<Tire> methodPlainTireProvider = Convertible.nullProvider();
    private Provider<Tire> methodSpareTireProvider = Convertible.nullProvider();
    @Inject
    static Seat staticFieldPlainSeat;
    @Inject
    @Drivers
    static Seat staticFieldDriversSeat;
    @Inject
    static Tire staticFieldPlainTire;
    @Inject
    @Named(value="spare")
    static Tire staticFieldSpareTire;
    @Inject
    static Provider<Seat> staticFieldPlainSeatProvider;
    @Inject
    @Drivers
    static Provider<Seat> staticFieldDriversSeatProvider;
    @Inject
    static Provider<Tire> staticFieldPlainTireProvider;
    @Inject
    @Named(value="spare")
    static Provider<Tire> staticFieldSpareTireProvider;
    private static Seat staticMethodPlainSeat;
    private static Seat staticMethodDriversSeat;
    private static Tire staticMethodPlainTire;
    private static Tire staticMethodSpareTire;
    private static Provider<Seat> staticMethodPlainSeatProvider;
    private static Provider<Seat> staticMethodDriversSeatProvider;
    private static Provider<Tire> staticMethodPlainTireProvider;
    private static Provider<Tire> staticMethodSpareTireProvider;
    public static ThreadLocal<Convertible> localConvertible;

    @Inject
    Convertible(Seat plainSeat, @Drivers Seat driversSeat, Tire plainTire, @Named(value="spare") Tire spareTire, Provider<Seat> plainSeatProvider, @Drivers Provider<Seat> driversSeatProvider, Provider<Tire> plainTireProvider, @Named(value="spare") Provider<Tire> spareTireProvider) {
        this.constructorPlainSeat = plainSeat;
        this.constructorDriversSeat = driversSeat;
        this.constructorPlainTire = plainTire;
        this.constructorSpareTire = spareTire;
        this.constructorPlainSeatProvider = plainSeatProvider;
        this.constructorDriversSeatProvider = driversSeatProvider;
        this.constructorPlainTireProvider = plainTireProvider;
        this.constructorSpareTireProvider = spareTireProvider;
    }

    Convertible() {
        throw new AssertionError((Object)"Unexpected call to non-injectable constructor");
    }

    void setSeat(Seat unused) {
        throw new AssertionError((Object)"Unexpected call to non-injectable method");
    }

    @Inject
    void injectMethodWithZeroArgs() {
        this.methodWithZeroParamsInjected = true;
    }

    @Inject
    String injectMethodWithNonVoidReturn() {
        this.methodWithNonVoidReturnInjected = true;
        return "unused";
    }

    @Inject
    void injectInstanceMethodWithManyArgs(Seat plainSeat, @Drivers Seat driversSeat, Tire plainTire, @Named(value="spare") Tire spareTire, Provider<Seat> plainSeatProvider, @Drivers Provider<Seat> driversSeatProvider, Provider<Tire> plainTireProvider, @Named(value="spare") Provider<Tire> spareTireProvider) {
        this.methodWithMultipleParamsInjected = true;
        this.methodPlainSeat = plainSeat;
        this.methodDriversSeat = driversSeat;
        this.methodPlainTire = plainTire;
        this.methodSpareTire = spareTire;
        this.methodPlainSeatProvider = plainSeatProvider;
        this.methodDriversSeatProvider = driversSeatProvider;
        this.methodPlainTireProvider = plainTireProvider;
        this.methodSpareTireProvider = spareTireProvider;
    }

    @Inject
    static void injectStaticMethodWithManyArgs(Seat plainSeat, @Drivers Seat driversSeat, Tire plainTire, @Named(value="spare") Tire spareTire, Provider<Seat> plainSeatProvider, @Drivers Provider<Seat> driversSeatProvider, Provider<Tire> plainTireProvider, @Named(value="spare") Provider<Tire> spareTireProvider) {
        staticMethodPlainSeat = plainSeat;
        staticMethodDriversSeat = driversSeat;
        staticMethodPlainTire = plainTire;
        staticMethodSpareTire = spareTire;
        staticMethodPlainSeatProvider = plainSeatProvider;
        staticMethodDriversSeatProvider = driversSeatProvider;
        staticMethodPlainTireProvider = plainTireProvider;
        staticMethodSpareTireProvider = spareTireProvider;
    }

    private static <T> Provider<T> nullProvider() {
        return new Provider<T>(){

            public T get() {
                return null;
            }
        };
    }

    static {
        staticFieldPlainSeatProvider = Convertible.nullProvider();
        staticFieldDriversSeatProvider = Convertible.nullProvider();
        staticFieldPlainTireProvider = Convertible.nullProvider();
        staticFieldSpareTireProvider = Convertible.nullProvider();
        staticMethodPlainSeatProvider = Convertible.nullProvider();
        staticMethodDriversSeatProvider = Convertible.nullProvider();
        staticMethodPlainTireProvider = Convertible.nullProvider();
        staticMethodSpareTireProvider = Convertible.nullProvider();
        localConvertible = new ThreadLocal();
    }

    public static class PrivateTests
    extends TestCase {
        private final Convertible car = localConvertible.get();
        private final Engine engine;
        private final SpareTire spareTire;

        public PrivateTests() {
            this.engine = (Engine)this.car.engineProvider.get();
            this.spareTire = this.car.spareTire;
        }

        public void testSupertypePrivateMethodInjected() {
            PrivateTests.assertTrue((boolean)this.spareTire.superPrivateMethodInjected);
            PrivateTests.assertTrue((boolean)this.spareTire.subPrivateMethodInjected);
        }

        public void testPackagePrivateMethodInjectedSamePackage() {
            PrivateTests.assertTrue((boolean)this.engine.subPackagePrivateMethodInjected);
            PrivateTests.assertFalse((boolean)this.engine.superPackagePrivateMethodInjected);
        }

        public void testPrivateMethodInjectedEvenWhenSimilarMethodLacksAnnotation() {
            PrivateTests.assertTrue((boolean)this.spareTire.subPrivateMethodForOverrideInjected);
        }

        public void testSimilarPrivateMethodInjectedOnlyOnce() {
            PrivateTests.assertFalse((boolean)this.spareTire.similarPrivateMethodInjectedTwice);
        }
    }

    public static class StaticTests
    extends TestCase {
        public void testSubtypeStaticFieldsInjected() {
            StaticTests.assertTrue((boolean)SpareTire.hasBeenStaticFieldInjected());
        }

        public void testSubtypeStaticMethodsInjected() {
            StaticTests.assertTrue((boolean)SpareTire.hasBeenStaticMethodInjected());
        }

        public void testSupertypeStaticFieldsInjected() {
            StaticTests.assertTrue((boolean)Tire.hasBeenStaticFieldInjected());
        }

        public void testSupertypeStaticMethodsInjected() {
            StaticTests.assertTrue((boolean)Tire.hasBeenStaticMethodInjected());
        }

        public void testStaticFieldInjectionWithValues() {
            StaticTests.assertFalse((String)"Expected unqualified value", (boolean)(staticFieldPlainSeat instanceof DriversSeat));
            StaticTests.assertFalse((String)"Expected unqualified value", (boolean)(staticFieldPlainTire instanceof SpareTire));
            StaticTests.assertTrue((String)"Expected qualified value", (boolean)(staticFieldDriversSeat instanceof DriversSeat));
            StaticTests.assertTrue((String)"Expected qualified value", (boolean)(staticFieldSpareTire instanceof SpareTire));
        }

        public void testStaticMethodInjectionWithValues() {
            StaticTests.assertFalse((String)"Expected unqualified value", (boolean)(staticMethodPlainSeat instanceof DriversSeat));
            StaticTests.assertFalse((String)"Expected unqualified value", (boolean)(staticMethodPlainTire instanceof SpareTire));
            StaticTests.assertTrue((String)"Expected qualified value", (boolean)(staticMethodDriversSeat instanceof DriversSeat));
            StaticTests.assertTrue((String)"Expected qualified value", (boolean)(staticMethodSpareTire instanceof SpareTire));
        }

        public void testStaticFieldsInjectedBeforeMethods() {
            StaticTests.assertFalse((boolean)SpareTire.staticMethodInjectedBeforeStaticFields);
        }

        public void testSupertypeStaticMethodsInjectedBeforeSubtypeStaticFields() {
            StaticTests.assertFalse((boolean)SpareTire.subtypeStaticFieldInjectedBeforeSupertypeStaticMethods);
        }

        public void testSupertypeStaticMethodsInjectedBeforeSubtypeStaticMethods() {
            StaticTests.assertFalse((boolean)SpareTire.subtypeStaticMethodInjectedBeforeSupertypeStaticMethods);
        }

        public void testStaticFieldInjectionWithProviders() {
            StaticTests.assertFalse((String)"Expected unqualified value", (boolean)(staticFieldPlainSeatProvider.get() instanceof DriversSeat));
            StaticTests.assertFalse((String)"Expected unqualified value", (boolean)(staticFieldPlainTireProvider.get() instanceof SpareTire));
            StaticTests.assertTrue((String)"Expected qualified value", (boolean)(staticFieldDriversSeatProvider.get() instanceof DriversSeat));
            StaticTests.assertTrue((String)"Expected qualified value", (boolean)(staticFieldSpareTireProvider.get() instanceof SpareTire));
        }

        public void testStaticMethodInjectionWithProviders() {
            StaticTests.assertFalse((String)"Expected unqualified value", (boolean)(staticMethodPlainSeatProvider.get() instanceof DriversSeat));
            StaticTests.assertFalse((String)"Expected unqualified value", (boolean)(staticMethodPlainTireProvider.get() instanceof SpareTire));
            StaticTests.assertTrue((String)"Expected qualified value", (boolean)(staticMethodDriversSeatProvider.get() instanceof DriversSeat));
            StaticTests.assertTrue((String)"Expected qualified value", (boolean)(staticMethodSpareTireProvider.get() instanceof SpareTire));
        }
    }

    public static class Tests
    extends TestCase {
        private final Convertible car = localConvertible.get();
        private final Cupholder cupholder;
        private final SpareTire spareTire;
        private final Tire plainTire;
        private final Engine engine;

        public Tests() {
            this.cupholder = this.car.cupholder;
            this.spareTire = this.car.spareTire;
            this.plainTire = this.car.fieldPlainTire;
            this.engine = (Engine)this.car.engineProvider.get();
        }

        public void testFieldsInjected() {
            Tests.assertTrue((this.cupholder != null && this.spareTire != null ? 1 : 0) != 0);
        }

        public void testProviderReturnedValues() {
            Tests.assertTrue((this.engine != null ? 1 : 0) != 0);
        }

        public void testMethodWithZeroParametersInjected() {
            Tests.assertTrue((boolean)this.car.methodWithZeroParamsInjected);
        }

        public void testMethodWithMultipleParametersInjected() {
            Tests.assertTrue((boolean)this.car.methodWithMultipleParamsInjected);
        }

        public void testNonVoidMethodInjected() {
            Tests.assertTrue((boolean)this.car.methodWithNonVoidReturnInjected);
        }

        public void testPublicNoArgsConstructorInjected() {
            Tests.assertTrue((boolean)this.engine.publicNoArgsConstructorInjected);
        }

        public void testSubtypeFieldsInjected() {
            Tests.assertTrue((boolean)this.spareTire.hasSpareTireBeenFieldInjected());
        }

        public void testSubtypeMethodsInjected() {
            Tests.assertTrue((boolean)this.spareTire.hasSpareTireBeenMethodInjected());
        }

        public void testSupertypeFieldsInjected() {
            Tests.assertTrue((boolean)this.spareTire.hasTireBeenFieldInjected());
        }

        public void testSupertypeMethodsInjected() {
            Tests.assertTrue((boolean)this.spareTire.hasTireBeenMethodInjected());
        }

        public void testTwiceOverriddenMethodInjectedWhenMiddleLacksAnnotation() {
            Tests.assertTrue((boolean)this.engine.overriddenTwiceWithOmissionInMiddleInjected);
        }

        public void testQualifiersNotInheritedFromOverriddenMethod() {
            Tests.assertFalse((boolean)this.engine.qualifiersInheritedFromOverriddenMethod);
        }

        public void testConstructorInjectionWithValues() {
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.constructorPlainSeat instanceof DriversSeat));
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.constructorPlainTire instanceof SpareTire));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.constructorDriversSeat instanceof DriversSeat));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.constructorSpareTire instanceof SpareTire));
        }

        public void testFieldInjectionWithValues() {
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.fieldPlainSeat instanceof DriversSeat));
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.fieldPlainTire instanceof SpareTire));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.fieldDriversSeat instanceof DriversSeat));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.fieldSpareTire instanceof SpareTire));
        }

        public void testMethodInjectionWithValues() {
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.methodPlainSeat instanceof DriversSeat));
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.methodPlainTire instanceof SpareTire));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.methodDriversSeat instanceof DriversSeat));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.methodSpareTire instanceof SpareTire));
        }

        public void testConstructorInjectionWithProviders() {
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.constructorPlainSeatProvider.get() instanceof DriversSeat));
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.constructorPlainTireProvider.get() instanceof SpareTire));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.constructorDriversSeatProvider.get() instanceof DriversSeat));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.constructorSpareTireProvider.get() instanceof SpareTire));
        }

        public void testFieldInjectionWithProviders() {
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.fieldPlainSeatProvider.get() instanceof DriversSeat));
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.fieldPlainTireProvider.get() instanceof SpareTire));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.fieldDriversSeatProvider.get() instanceof DriversSeat));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.fieldSpareTireProvider.get() instanceof SpareTire));
        }

        public void testMethodInjectionWithProviders() {
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.methodPlainSeatProvider.get() instanceof DriversSeat));
            Tests.assertFalse((String)"Expected unqualified value", (boolean)(this.car.methodPlainTireProvider.get() instanceof SpareTire));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.methodDriversSeatProvider.get() instanceof DriversSeat));
            Tests.assertTrue((String)"Expected qualified value", (boolean)(this.car.methodSpareTireProvider.get() instanceof SpareTire));
        }

        public void testConstructorInjectedProviderYieldsSingleton() {
            Tests.assertSame((String)"Expected same value", (Object)this.car.constructorPlainSeatProvider.get(), (Object)this.car.constructorPlainSeatProvider.get());
        }

        public void testFieldInjectedProviderYieldsSingleton() {
            Tests.assertSame((String)"Expected same value", (Object)this.car.fieldPlainSeatProvider.get(), (Object)this.car.fieldPlainSeatProvider.get());
        }

        public void testMethodInjectedProviderYieldsSingleton() {
            Tests.assertSame((String)"Expected same value", (Object)this.car.methodPlainSeatProvider.get(), (Object)this.car.methodPlainSeatProvider.get());
        }

        public void testCircularlyDependentSingletons() {
            Tests.assertSame((Object)((Seat)this.cupholder.seatProvider.get()).getCupholder(), (Object)this.cupholder);
        }

        public void testSingletonAnnotationNotInheritedFromSupertype() {
            Tests.assertNotSame((Object)this.car.driversSeatA, (Object)this.car.driversSeatB);
        }

        public void testConstructorInjectedProviderYieldsDistinctValues() {
            Tests.assertNotSame((String)"Expected distinct values", (Object)this.car.constructorDriversSeatProvider.get(), (Object)this.car.constructorDriversSeatProvider.get());
            Tests.assertNotSame((String)"Expected distinct values", (Object)this.car.constructorPlainTireProvider.get(), (Object)this.car.constructorPlainTireProvider.get());
            Tests.assertNotSame((String)"Expected distinct values", (Object)this.car.constructorSpareTireProvider.get(), (Object)this.car.constructorSpareTireProvider.get());
        }

        public void testFieldInjectedProviderYieldsDistinctValues() {
            Tests.assertNotSame((String)"Expected distinct values", (Object)this.car.fieldDriversSeatProvider.get(), (Object)this.car.fieldDriversSeatProvider.get());
            Tests.assertNotSame((String)"Expected distinct values", (Object)this.car.fieldPlainTireProvider.get(), (Object)this.car.fieldPlainTireProvider.get());
            Tests.assertNotSame((String)"Expected distinct values", (Object)this.car.fieldSpareTireProvider.get(), (Object)this.car.fieldSpareTireProvider.get());
        }

        public void testMethodInjectedProviderYieldsDistinctValues() {
            Tests.assertNotSame((String)"Expected distinct values", (Object)this.car.methodDriversSeatProvider.get(), (Object)this.car.methodDriversSeatProvider.get());
            Tests.assertNotSame((String)"Expected distinct values", (Object)this.car.methodPlainTireProvider.get(), (Object)this.car.methodPlainTireProvider.get());
            Tests.assertNotSame((String)"Expected distinct values", (Object)this.car.methodSpareTireProvider.get(), (Object)this.car.methodSpareTireProvider.get());
        }

        public void testPackagePrivateMethodInjectedDifferentPackages() {
            Tests.assertTrue((boolean)this.spareTire.subPackagePrivateMethodInjected);
            Tests.assertTrue((boolean)this.spareTire.superPackagePrivateMethodInjected);
        }

        public void testOverriddenProtectedMethodInjection() {
            Tests.assertTrue((boolean)this.spareTire.subProtectedMethodInjected);
            Tests.assertFalse((boolean)this.spareTire.superProtectedMethodInjected);
        }

        public void testOverriddenPublicMethodNotInjected() {
            Tests.assertTrue((boolean)this.spareTire.subPublicMethodInjected);
            Tests.assertFalse((boolean)this.spareTire.superPublicMethodInjected);
        }

        public void testFieldsInjectedBeforeMethods() {
            Tests.assertFalse((boolean)this.spareTire.methodInjectedBeforeFields);
        }

        public void testSupertypeMethodsInjectedBeforeSubtypeFields() {
            Tests.assertFalse((boolean)this.spareTire.subtypeFieldInjectedBeforeSupertypeMethods);
        }

        public void testSupertypeMethodInjectedBeforeSubtypeMethods() {
            Tests.assertFalse((boolean)this.spareTire.subtypeMethodInjectedBeforeSupertypeMethods);
        }

        public void testPackagePrivateMethodInjectedEvenWhenSimilarMethodLacksAnnotation() {
            Tests.assertTrue((boolean)this.spareTire.subPackagePrivateMethodForOverrideInjected);
        }

        public void testPrivateMethodNotInjectedWhenSupertypeHasAnnotatedSimilarMethod() {
            Tests.assertFalse((boolean)this.spareTire.superPrivateMethodForOverrideInjected);
        }

        public void testPackagePrivateMethodNotInjectedWhenOverrideLacksAnnotation() {
            Tests.assertFalse((boolean)this.engine.subPackagePrivateMethodForOverrideInjected);
            Tests.assertFalse((boolean)this.engine.superPackagePrivateMethodForOverrideInjected);
        }

        public void testPackagePrivateMethodNotInjectedWhenSupertypeHasAnnotatedSimilarMethod() {
            Tests.assertFalse((boolean)this.spareTire.superPackagePrivateMethodForOverrideInjected);
        }

        public void testProtectedMethodNotInjectedWhenOverrideNotAnnotated() {
            Tests.assertFalse((boolean)this.spareTire.protectedMethodForOverrideInjected);
        }

        public void testPublicMethodNotInjectedWhenOverrideNotAnnotated() {
            Tests.assertFalse((boolean)this.spareTire.publicMethodForOverrideInjected);
        }

        public void testTwiceOverriddenMethodNotInjectedWhenOverrideLacksAnnotation() {
            Tests.assertFalse((boolean)this.engine.overriddenTwiceWithOmissionInSubclassInjected);
        }

        public void testOverriddingMixedWithPackagePrivate2() {
            Tests.assertTrue((boolean)this.spareTire.packagePrivateMethod2Injected);
            Tests.assertTrue((boolean)((Tire)this.spareTire).packagePrivateMethod2Injected);
            Tests.assertFalse((boolean)((RoundThing)this.spareTire).packagePrivateMethod2Injected);
            Tests.assertTrue((boolean)this.plainTire.packagePrivateMethod2Injected);
            Tests.assertTrue((boolean)((RoundThing)this.plainTire).packagePrivateMethod2Injected);
        }

        public void testOverriddingMixedWithPackagePrivate3() {
            Tests.assertFalse((boolean)this.spareTire.packagePrivateMethod3Injected);
            Tests.assertTrue((boolean)((Tire)this.spareTire).packagePrivateMethod3Injected);
            Tests.assertFalse((boolean)((RoundThing)this.spareTire).packagePrivateMethod3Injected);
            Tests.assertTrue((boolean)this.plainTire.packagePrivateMethod3Injected);
            Tests.assertTrue((boolean)((RoundThing)this.plainTire).packagePrivateMethod3Injected);
        }

        public void testOverriddingMixedWithPackagePrivate4() {
            Tests.assertFalse((boolean)this.plainTire.packagePrivateMethod4Injected);
            Tests.assertTrue((boolean)((RoundThing)this.plainTire).packagePrivateMethod4Injected);
        }

        public void testOverriddenPackagePrivateMethodInjectedOnlyOnce() {
            Tests.assertFalse((boolean)this.engine.overriddenPackagePrivateMethodInjectedTwice);
        }

        public void testSimilarPackagePrivateMethodInjectedOnlyOnce() {
            Tests.assertFalse((boolean)this.spareTire.similarPackagePrivateMethodInjectedTwice);
        }

        public void testOverriddenProtectedMethodInjectedOnlyOnce() {
            Tests.assertFalse((boolean)this.spareTire.overriddenProtectedMethodInjectedTwice);
        }

        public void testOverriddenPublicMethodInjectedOnlyOnce() {
            Tests.assertFalse((boolean)this.spareTire.overriddenPublicMethodInjectedTwice);
        }
    }
}

