/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.inject.build.compatible.spi;

import jakarta.enterprise.inject.build.compatible.spi.AnnotationBuilderFactory;
import jakarta.enterprise.inject.build.compatible.spi.SecurityActions;
import jakarta.enterprise.inject.spi.Prioritized;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;

final class AnnotationBuilderFactoryResolver {
    private static final Object lock = new Object();
    private static volatile Set<AnnotationBuilderFactory> discoveredFactories;
    private static volatile AnnotationBuilderFactory configuredFactory;

    AnnotationBuilderFactoryResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AnnotationBuilderFactory get() {
        if (configuredFactory != null) {
            return configuredFactory;
        }
        if (discoveredFactories == null) {
            Object object = lock;
            synchronized (object) {
                if (discoveredFactories == null) {
                    AnnotationBuilderFactoryResolver.discoverFactories();
                }
            }
        }
        configuredFactory = discoveredFactories.iterator().next();
        return configuredFactory;
    }

    private static void discoverFactories() {
        TreeSet<AnnotationBuilderFactory> factories = new TreeSet<AnnotationBuilderFactory>(Comparator.comparingInt(Prioritized::getPriority).reversed());
        ServiceLoader<AnnotationBuilderFactory> loader = SecurityActions.loadService(AnnotationBuilderFactory.class, AnnotationBuilderFactoryResolver.class.getClassLoader());
        if (!loader.iterator().hasNext()) {
            throw new IllegalStateException("Unable to locate AnnotationBuilderFactory implementation");
        }
        try {
            for (AnnotationBuilderFactory factory : loader) {
                factories.add(factory);
            }
        }
        catch (ServiceConfigurationError e) {
            throw new IllegalStateException(e);
        }
        discoveredFactories = Collections.unmodifiableSet(factories);
    }
}

