/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.metadata;

import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;

public final class CollectMetaData {
    private static final String FRAMEWORK_PACKAGE_PREFIX = "ee/jakarta/tck/concurrent/framework";
    private static final String RUNTIME_TESTS_FILE = "runtime-tests.adoc";
    private static final String CHALLENGED_TESTS_FILE = "successful-challenges.adoc";
    private static final String SIG_OUTPUT_FILE = "expected-sig-output.adoc";
    private static final String EXPECTED_OUTPUT_FILE = "expected-output.adoc";
    private static final String TEST_PROPERTIES_FILE = "test-properties.adoc";
    private static boolean debug = false;
    private static List<String> apiPackages;
    private static List<Class<?>> testClasses;
    private static File adocGeneratedLocation;

    private CollectMetaData() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new RuntimeException("CollectMetaData expected exactly 3 arguments [debug, path-to-tck, output-file-location]");
        }
        debug = Boolean.valueOf(args[0]);
        testClasses = CollectMetaData.getClassNames(args[1]);
        adocGeneratedLocation = new File(args[2]);
        if (!adocGeneratedLocation.exists()) {
            adocGeneratedLocation.mkdirs();
        }
        List<TestMetaData> testMetaData = CollectMetaData.collectMetaData();
        CollectMetaData.writeTestCounts(testMetaData, new File(adocGeneratedLocation, RUNTIME_TESTS_FILE));
        CollectMetaData.writeSuccessfulChallenges(testMetaData, new File(adocGeneratedLocation, CHALLENGED_TESTS_FILE));
        CollectMetaData.writeSigOutput(new File(adocGeneratedLocation, SIG_OUTPUT_FILE));
        CollectMetaData.writeOutput(testMetaData, new File(adocGeneratedLocation, EXPECTED_OUTPUT_FILE));
        CollectMetaData.writeGitIgnore(new File(adocGeneratedLocation, ".gitignore"), RUNTIME_TESTS_FILE, CHALLENGED_TESTS_FILE, SIG_OUTPUT_FILE, EXPECTED_OUTPUT_FILE, TEST_PROPERTIES_FILE);
    }

    private static void writeGitIgnore(File outputLocation, String ... ignoredFiles) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            for (String ignoredFile : ignoredFiles) {
                writer.write(ignoredFile + System.lineSeparator());
            }
        }
    }

    private static void writeOutput(List<TestMetaData> testMetaData, File outputLocation) throws IOException {
        String output = "[source, txt]\n----\n$ mvn clean test\n...\n[INFO] --- maven-surefire-plugin:3.0.0-M7:test (default-test) @ tck.runner ---\n[INFO] Using auto detected provider org.apache.maven.surefire.junitplatform.JUnitPlatformProvider\n[INFO]\n[INFO] -------------------------------------------------------\n[INFO]  T E S T S\n[INFO] -------------------------------------------------------\n$indiviualTests\n[INFO] Results:\n[INFO]\n$totalTests\n[INFO]\n[INFO] -------------------------------------------------------\n[INFO] BUILD SUCCESS\n[INFO] -------------------------------------------------------\n[INFO] Total time:  xx.xxx s\n[INFO] Finished at: yyyy-mm-ddThh:mm:ss.mmmm\n[INFO] -------------------------------------------------------\n----".replaceAll("\\$indiviualTests", CollectMetaData.getIndividualTests(testMetaData)).replaceAll("\\$totalTests", CollectMetaData.getTotalTests(testMetaData));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            writer.write(output.trim() + System.lineSeparator());
        }
    }

    private static String getIndividualTests(List<TestMetaData> testMetaData) {
        StringBuffer output = new StringBuffer();
        String nl = System.lineSeparator();
        for (String testClass : testMetaData.stream().map(metaData -> metaData.testClass).distinct().collect(Collectors.toList())) {
            List theseTests = testMetaData.stream().filter(metaData -> metaData.testClass == testClass).collect(Collectors.toList());
            long testCount = theseTests.stream().filter(metaData -> !metaData.isDisabled).count();
            long disabledCount = theseTests.stream().filter(metaData -> metaData.isDisabled).count();
            output.append("[INFO] Running " + testClass + nl);
            if (disabledCount > 0L) {
                output.append("[WARNING] Tests run: " + testCount + ", Failures: 0, Errors: 0, Skipped: " + disabledCount + ",");
            } else {
                output.append("[INFO] Tests run: " + testCount + ", Failures: 0, Errors: 0, Skipped: " + disabledCount + ",");
            }
            output.append("Time elapsed: y.yy s - in " + testClass + nl);
            output.append("[INFO]" + nl);
        }
        return output.toString().trim();
    }

    private static String getTotalTests(List<TestMetaData> testMetaData) {
        long totalTestCount = testMetaData.stream().filter(metaData -> !metaData.isDisabled).count();
        long totalDisabledCount = testMetaData.stream().filter(metaData -> metaData.isDisabled).count();
        if (totalDisabledCount > 0L) {
            return "[WARNING] Tests run: " + totalTestCount + ", Failures: 0, Errors: 0, Skipped: " + totalDisabledCount;
        }
        return "[INFO] Tests run: " + totalTestCount + ", Failures: 0, Errors: 0, Skipped: " + totalDisabledCount;
    }

    private static void writeSigOutput(File outputLocation) throws IOException {
        String output = "[source, txt]\n----\n******************************************************\nAll package signatures passed.\n    Passed packages listed below:\n$packages\n******************************************************\n----".replaceAll("\\$packages", CollectMetaData.getPackages());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            writer.write(output.trim() + System.lineSeparator());
        }
    }

    private static String getPackages() {
        Object output = "";
        for (String apiPackage : apiPackages) {
            output = (String)output + "$package(static mode)\n$package(reflection mode)\n".indent(8).replaceAll("\\$package", apiPackage);
        }
        return output;
    }

    private static void writeSuccessfulChallenges(List<TestMetaData> testMetaData, File outputLocation) throws IOException {
        String output = "|===\n|Class |Method |Link |Version\n$disabledTests\n|===".replaceAll("\\$disabledTests", CollectMetaData.getDisabledTests(testMetaData));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            writer.write(output.trim() + System.lineSeparator());
        }
    }

    private static String getDisabledTests(List<TestMetaData> testMetaData) {
        List<TestMetaData> disabledTests = testMetaData.stream().filter(TestMetaData::isDisabled).toList();
        Object output = "";
        for (TestMetaData disabledTest : disabledTests) {
            output = (String)output + "\n|%s |%s |%s |%s\n".formatted(disabledTest.testClass.substring(disabledTest.testClass.lastIndexOf(46) + 1), disabledTest.testName, disabledTest.challengeIssue, disabledTest.challengeVersion);
        }
        return output;
    }

    private static void writeTestCounts(List<TestMetaData> testMetaData, File outputLocation) throws IOException {
        String output = "|===\n|standalone |core |web |full\n\n|%d         |%d   |%d  |%d\n\n|===".formatted(CollectMetaData.getTestCounts(testMetaData));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            writer.write(output.trim() + System.lineSeparator());
        }
    }

    private static Object[] getTestCounts(List<TestMetaData> testMetaData) {
        List runnableTestMetaData = testMetaData.stream().filter(TestMetaData::isRunnable).collect(Collectors.toList());
        ArrayList<Long> results = new ArrayList<Long>();
        results.add(runnableTestMetaData.stream().filter(TestMetaData::isStandalone).count());
        results.add(runnableTestMetaData.stream().filter(TestMetaData::isCore).count());
        results.add(runnableTestMetaData.stream().filter(TestMetaData::isWeb).count());
        results.add(runnableTestMetaData.stream().filter(TestMetaData::isFull).count());
        return results.toArray();
    }

    private static List<TestMetaData> collectMetaData() {
        return testClasses.stream().flatMap(clazz -> AnnotationSupport.findAnnotatedMethods((Class)clazz, Test.class, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).stream()).map(method -> {
            boolean isDisabled = method.isAnnotationPresent(Challenge.class);
            TestMetaData metaData = new TestMetaData(method.getDeclaringClass().getCanonicalName(), method.getName(), method.getAnnotation(Assertion.class).strategy(), isDisabled, isDisabled ? method.getAnnotation(Challenge.class).link() : "", isDisabled ? method.getAnnotation(Challenge.class).version() : "", CollectMetaData.findTags(method.getDeclaringClass()));
            return metaData;
        }).collect(Collectors.toList());
    }

    private static List<String> findTags(Class<?> clazz) {
        return Arrays.stream(clazz.getAnnotations()).flatMap(anno -> Stream.concat(Arrays.stream(anno.annotationType().getAnnotations()), Stream.of(anno))).flatMap(anno -> {
            if (anno instanceof Tag) {
                return Stream.of((Tag)anno);
            }
            if (anno instanceof Tags) {
                return Arrays.stream(((Tags)anno).value());
            }
            return Stream.empty();
        }).map(anno -> anno.value()).collect(Collectors.toList());
    }

    private static List<Class<?>> getClassNames(String jarLocation) throws Exception {
        ArrayList classList = new ArrayList();
        try (JarInputStream jar = new JarInputStream(new FileInputStream(jarLocation));){
            JarEntry entry = jar.getNextJarEntry();
            while (entry != null) {
                if (CollectMetaData.isTestClass(entry.getName())) {
                    CollectMetaData.debug("Attempting to load test class: " + entry.getName());
                    classList.add(CollectMetaData.getClass(entry.getName().replaceAll("/", "\\.")));
                } else if (entry.getName().contains("sig-test-pkg-list.txt")) {
                    CollectMetaData.debug("Attempting to read package list" + entry.getName());
                    apiPackages = new String(jar.readAllBytes(), StandardCharsets.UTF_8).lines().filter(line -> !line.contains("#")).filter(line -> !line.isBlank()).collect(Collectors.toList());
                    CollectMetaData.debug("apiPackages populated with: " + apiPackages.toString());
                }
                jar.closeEntry();
                entry = jar.getNextJarEntry();
            }
        }
        return classList;
    }

    private static boolean isTestClass(String entryName) {
        if (!entryName.endsWith(".class")) {
            return false;
        }
        if (entryName.contains(FRAMEWORK_PACKAGE_PREFIX)) {
            return false;
        }
        return entryName.substring(entryName.lastIndexOf("/"), entryName.lastIndexOf(".")).toLowerCase().contains("tests");
    }

    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className.substring(0, className.lastIndexOf(46)));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void debug(String message) {
        if (debug) {
            System.out.println(message);
        }
    }

    public record TestMetaData(String testClass, String testName, String assertion, boolean isDisabled, String challengeIssue, String challengeVersion, List<String> tags) {
        boolean isStandalone() {
            return this.tags.contains("standalone");
        }

        boolean isCore() {
            return this.tags.contains("core");
        }

        boolean isWeb() {
            return this.tags.contains("web");
        }

        boolean isFull() {
            return this.tags.contains("full");
        }

        boolean isRunnable() {
            return !this.isDisabled;
        }

        @Override
        public String toString() {
            return "TestMetaData [testName=" + this.testName + ", assertion=" + this.assertion + ", isDisabled=" + this.isDisabled + ", challengeIssue=" + this.challengeIssue + ", challengeVersion" + this.challengeVersion + ", tags=" + this.tags + "]";
        }
    }
}

