/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.web.cdi.provider;

import ee.jakarta.tck.data.common.cdi.PersonEntity;
import ee.jakarta.tck.data.web.cdi.provider.DirectoryRepositoryProducer;
import jakarta.data.exceptions.MappingException;
import jakarta.data.repository.DataRepository;
import jakarta.data.repository.Repository;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

public class PersonExtension
implements Extension {
    private static final Logger log = Logger.getLogger(PersonExtension.class.getCanonicalName());
    private final ArrayList<Bean<?>> repositoryBeans = new ArrayList();
    private final HashSet<AnnotatedType<?>> repositoryTypes = new HashSet();

    public <T> void annotatedRepository(@Observes @WithAnnotations(value={Repository.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        Repository repository = (Repository)type.getAnnotation(Repository.class);
        String provider = repository.provider();
        if ("PERSON_PROVIDER".equals(provider)) {
            log.info("Person CDI Extension: adding repository " + repository.toString() + " " + type.getJavaClass().getName());
            this.repositoryTypes.add(type);
        } else {
            log.info("Person CDI Extension: ignore repository " + repository.toString() + " " + type.getJavaClass().getName());
        }
    }

    public void afterTypeDiscovery(@Observes AfterTypeDiscovery event, BeanManager beanMgr) {
        for (AnnotatedType<?> repositoryType : this.repositoryTypes) {
            Class repositoryInterface = repositoryType.getJavaClass();
            Class entityClass = null;
            for (Type interfaceType : repositoryInterface.getGenericInterfaces()) {
                Type[] typeParams;
                ParameterizedType parameterizedType;
                if (!(interfaceType instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)interfaceType).getRawType().getTypeName().startsWith(DataRepository.class.getPackageName()) || (typeParams = parameterizedType.getActualTypeArguments()).length != 2 || !(typeParams[0] instanceof Class)) continue;
                entityClass = (Class)typeParams[0];
                break;
            }
            if (entityClass == null) {
                throw new MappingException("Did not find the entity class for " + repositoryInterface);
            }
            PersonEntity entityAnno = entityClass.getAnnotation(PersonEntity.class);
            if (entityAnno == null) {
                Repository repository = (Repository)repositoryType.getAnnotation(Repository.class);
                if ("".equals(repository.provider())) continue;
                String message = "The Person Jakarta Data provider cannot provide the " + repositoryType.getJavaClass().getName() + " repository because the repository's " + entityClass.getName() + " entity class is not annotated with " + PersonEntity.class.getName();
                throw new MappingException(message);
            }
            BeanAttributes attrs = beanMgr.createBeanAttributes(repositoryType);
            Bean bean = beanMgr.createBean(attrs, repositoryInterface, new DirectoryRepositoryProducer.Factory());
            this.repositoryBeans.add(bean);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanMgr) {
        for (Bean<?> bean : this.repositoryBeans) {
            event.addBean(bean);
        }
    }
}

