/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.core.cdi.provider;

import ee.jakarta.tck.data.core.cdi.provider.PersonBeanCreator;
import jakarta.data.repository.Repository;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.Enhancement;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanBuilder;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.inject.build.compatible.spi.Types;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DirectoryBuildCompatibleExtension
implements BuildCompatibleExtension {
    private static final Logger log = Logger.getLogger(DirectoryBuildCompatibleExtension.class.getCanonicalName());
    private final List<String> repositoryClassNames = new ArrayList<String>();

    @Enhancement(withAnnotations={Repository.class}, types={Object.class}, withSubtypes=true)
    public void enhancement(ClassInfo repositoryClassInfo) {
        AnnotationInfo repositoryAnnotationInfo = repositoryClassInfo.annotation(Repository.class);
        AnnotationMember providerMember = repositoryAnnotationInfo.member("provider");
        String provider = providerMember.asString();
        boolean providesRepository = "PERSON_PROVIDER".equals(provider);
        log.info("During enhancement, found " + repositoryClassInfo + " with provider of " + provider);
        if (providesRepository) {
            log.info("This extension provides for the repository: " + repositoryClassInfo.name());
            this.repositoryClassNames.add(repositoryClassInfo.name());
        } else {
            log.info("This extension does not provides for the repository: " + repositoryClassInfo.name());
        }
    }

    @Synthesis
    public void synthesis(Types types, SyntheticComponents synth) throws ClassNotFoundException {
        for (String repoClassName : this.repositoryClassNames) {
            Class<?> repoClass = Class.forName(repoClassName);
            SyntheticBeanBuilder builder = synth.addBean(repoClass).name(repoClassName).type((Type)types.ofClass(repoClassName)).scope(ApplicationScoped.class).withParam("provider", "PERSON_PROVIDER").createWith(PersonBeanCreator.class);
            log.info("Registered " + repoClassName + " bean with " + builder);
        }
    }
}

