/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.signature;

import ee.jakarta.tck.data.framework.signature.SignatureTestDriver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedList;

public final class ApiCheckDriver
extends SignatureTestDriver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BASE_FLAG = "-base";
    private static final String TEST_FLAG = "-test";
    private static final String PACKAGE_NO_SUBS_FLAG = "-PackageWithoutSubpackages";
    private static final String PACKAGE_FLAG = "-package";
    private static final String EXPACKAGE_FLAG = "-expackage";
    private static final String REFLECT_FLAG = "-reflect";
    private static final String CONST_FLAG = "-constvalues";

    @Override
    protected String normalizeFileName(File f) {
        return f.getPath();
    }

    @Override
    protected String[] createTestArguments(String packageListFile, String mapFile, String signatureRepositoryDir, String packageOrClassUnderTest, String classpath, boolean bStaticMode) throws Exception {
        Class<?> pkgListClass = Class.forName("javasoft.sqe.apiCheck.PackageList");
        Constructor<?> pkgCtor = pkgListClass.getDeclaredConstructor(String.class);
        Object pkgInstance = pkgCtor.newInstance(packageListFile);
        Method pkgMethod = pkgListClass.getDeclaredMethod("getSubPackagesFormatted", String.class);
        String excludePkgs = (String)pkgMethod.invoke(pkgInstance, packageOrClassUnderTest);
        LinkedList<String> sigArgsList = new LinkedList<String>();
        sigArgsList.add(BASE_FLAG);
        sigArgsList.add(this.getSigFileInfo(packageOrClassUnderTest, mapFile, signatureRepositoryDir).getFile());
        if (classpath != null && classpath.length() > 0) {
            sigArgsList.add(TEST_FLAG);
            sigArgsList.add(classpath);
        }
        sigArgsList.add(REFLECT_FLAG);
        sigArgsList.add(CONST_FLAG);
        sigArgsList.add(PACKAGE_FLAG);
        sigArgsList.add(packageOrClassUnderTest);
        if (excludePkgs != null && excludePkgs.length() > 0) {
            sigArgsList.add(EXPACKAGE_FLAG);
            sigArgsList.add(excludePkgs);
        }
        return sigArgsList.toArray(new String[sigArgsList.size()]);
    }

    @Override
    protected boolean runSignatureTest(String packageOrClassName, String[] testArguments) throws Exception {
        Class<?> diffClass = Class.forName("javasoft.sqe.apiCheck.Diff");
        Method mainMethod = diffClass.getDeclaredMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{testArguments});
        Method diffMethod = diffClass.getDeclaredMethod("diffsFound", new Class[0]);
        return (Boolean)diffMethod.invoke(null, new Object[0]) == false;
    }

    @Override
    protected boolean runPackageSearch(String packageOrClassName, String[] testArguments) throws Exception {
        int ii;
        Class<?> sigTestClass = Class.forName("com.sun.tdk.signaturetest.SignatureTest");
        Object sigTestInstance = sigTestClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (ii = 0; ii < testArguments.length; ++ii) {
            if (!testArguments[ii].equals(PACKAGE_FLAG)) continue;
            testArguments[ii] = PACKAGE_NO_SUBS_FLAG;
        }
        System.out.println("\nCalling:  com.sun.tdk.signaturetest.SignatureTest() with following args:");
        for (ii = 0; ii < testArguments.length; ++ii) {
            System.out.println("\t  testArguments[" + ii + "] = " + testArguments[ii]);
        }
        Method runMethod = sigTestClass.getDeclaredMethod("run", String[].class, PrintWriter.class, PrintWriter.class);
        runMethod.invoke(sigTestInstance, testArguments, new PrintWriter(output, true), null);
        String rawMessages = output.toString();
        System.out.println("********** Status Report '" + packageOrClassName + "' **********\n");
        System.out.println(rawMessages);
        return sigTestInstance.toString().substring(7).startsWith("Passed.");
    }

    @Override
    protected boolean verifyJTAJarForNoXA(String classpath, String repositoryDir) throws Exception {
        return true;
    }
}

