/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.standalone.persistence;

import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.Persistence;
import ee.jakarta.tck.data.framework.junit.anno.Standalone;
import ee.jakarta.tck.data.standalone.persistence.Catalog;
import ee.jakarta.tck.data.standalone.persistence.Product;
import jakarta.data.Sort;
import jakarta.data.Streamable;
import jakarta.data.exceptions.EntityExistsException;
import jakarta.data.exceptions.MappingException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;

@Standalone
@Persistence
public class PersistenceEntityTests {
    @Inject
    Catalog catalog;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Product.class, Catalog.class});
    }

    @Assertion(id="133", strategy="Use a repository method with Contains to query for a value with a collection attribute.")
    public void testContainsInCollection() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.catalog.save(Product.of("spade", 9.99, "TEST-PROD-21", Product.Department.TOOLS, Product.Department.GARDEN));
        this.catalog.save(Product.of("shelves", 109.88, "TEST-PROD-22", Product.Department.FURNITURE, Product.Department.OFFICE));
        this.catalog.save(Product.of("desk", 315.98, "TEST-PROD-23", Product.Department.FURNITURE, Product.Department.OFFICE));
        this.catalog.save(Product.of("stapler", 6.79, "TEST-PROD-24", Product.Department.OFFICE));
        Product[] found = this.catalog.findByDepartmentsContains(Product.Department.FURNITURE);
        Assertions.assertEquals((int)2, (int)found.length);
        Assertions.assertEquals((Object)"desk", (Object)found[0].getName());
        Assertions.assertEquals((Object)"shelves", (Object)found[1].getName());
        found = this.catalog.findByDepartmentsContains(Product.Department.OFFICE);
        Assertions.assertEquals((int)3, (int)found.length);
        Assertions.assertEquals((Object)"desk", (Object)found[0].getName());
        Assertions.assertEquals((Object)"shelves", (Object)found[1].getName());
        Assertions.assertEquals((Object)"stapler", (Object)found[2].getName());
        Assertions.assertEquals((long)4L, (long)this.catalog.deleteByProductNumLike("TEST-PROD-%"));
    }

    @Assertion(id="133", strategy="Use a repository method with the Empty keyword.")
    public void testEmpty() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.catalog.save(Product.of("refrigerator", 889.3, "TEST-PROD-41", Product.Department.APPLIANCES));
        this.catalog.save(Product.of("book", 15.98, "TEST-PROD-42", new Product.Department[0]));
        this.catalog.save(Product.of("baseball cap", 10.99, "TEST-PROD-43", Product.Department.SPORTING_GOODS, Product.Department.CLOTHING));
        LinkedList<Product> found = this.catalog.findByDepartmentsEmpty();
        Assertions.assertEquals((int)1, (int)found.size());
        Assertions.assertEquals((Object)"book", (Object)found.getFirst().getName());
        Assertions.assertEquals((long)3L, (long)this.catalog.deleteByProductNumLike("TEST-PROD-%"));
    }

    @Assertion(id="133", strategy="Use a repository method that obtains the Entity Manager.")
    public void testEntityManager() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.catalog.save(Product.of("bicycle", 359.98, "TEST-PROD-81", Product.Department.SPORTING_GOODS));
        this.catalog.save(Product.of("shin guards", 8.99, "TEST-PROD-83", Product.Department.SPORTING_GOODS));
        this.catalog.save(Product.of("dishwasher", 788.1, "TEST-PROD-86", Product.Department.APPLIANCES));
        this.catalog.save(Product.of("socks", 5.99, "TEST-PROD-87", Product.Department.CLOTHING));
        this.catalog.save(Product.of("volleyball", 10.99, "TEST-PROD-89", Product.Department.SPORTING_GOODS));
        Assertions.assertEquals((double)385.95, (double)this.catalog.sumPrices(Product.Department.CLOTHING, Product.Department.SPORTING_GOODS), (double)0.001);
        Assertions.assertEquals((double)794.09, (double)this.catalog.sumPrices(Product.Department.CLOTHING, Product.Department.APPLIANCES), (double)0.001);
    }

    @Assertion(id="133", strategy="Use a repository method findByIdBetween where the entity's Id attribute is named something other than id.")
    public void testIdAttributeWithDifferentName() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.catalog.save(Product.of("apple", 1.19, "TEST-PROD-12", Product.Department.GROCERY));
        this.catalog.save(Product.of("pear", 0.99, "TEST-PROD-14", Product.Department.GROCERY));
        this.catalog.save(Product.of("orange", 1.09, "TEST-PROD-16", Product.Department.GROCERY));
        this.catalog.save(Product.of("banana", 0.49, "TEST-PROD-17", Product.Department.GROCERY));
        this.catalog.save(Product.of("plum", 0.89, "TEST-PROD-18", Product.Department.GROCERY));
        Iterable<Product> found = this.catalog.findByIdBetween("TEST-PROD-13", "TEST-PROD-17", Sort.asc((String)"name"));
        Iterator<Product> it = found.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((Object)"banana", (Object)it.next().getName());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((Object)"orange", (Object)it.next().getName());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((Object)"pear", (Object)it.next().getName());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
        Assertions.assertEquals((long)5L, (long)this.catalog.deleteByProductNumLike("TEST-PROD-%"));
    }

    @Assertion(id="133", strategy="Attempt to insert an entity that already exists in the database and expect EntityExistsException.")
    public void testInsertEntityThatAlreadyExists() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        Product prod1 = this.catalog.add(Product.of("watermelon", 6.29, "TEST-PROD-94", Product.Department.GROCERY));
        try {
            this.catalog.add(Product.of("pineapple", 1.99, "TEST-PROD-94", Product.Department.GROCERY));
            Assertions.fail((String)"Should not be able to insert an entity that has same Id as another entity.");
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)true, (Object)this.catalog.remove(prod1));
    }

    @Assertion(id="133", strategy="Use a repository method with the Like keyword.")
    public void testLike() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.catalog.save(Product.of("celery", 1.57, "TEST-PROD-31", Product.Department.GROCERY));
        this.catalog.save(Product.of("mushrooms", 1.89, "TEST-PROD-32", Product.Department.GROCERY));
        this.catalog.save(Product.of("carrots", 1.39, "TEST-PROD-33", Product.Department.GROCERY));
        List<Product> found = this.catalog.findByNameLike("%r_o%");
        Assertions.assertEquals(List.of("carrots", "mushrooms"), found.stream().map(Product::getName).sorted().collect(Collectors.toList()));
        Assertions.assertEquals((long)3L, (long)this.catalog.deleteByProductNumLike("TEST-PROD-%"));
    }

    @Assertion(id="119", strategy="Ensure that this test is only run when provider supports persistence entities")
    public void testNotRunOnNOSQL() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(Product.of("pen", 2.5, "TEST-PROD-01", new Product.Department[0]));
        products.add(Product.of("pencil", 1.25, "TEST-PROD-02", new Product.Department[0]));
        products.add(Product.of("marker", 3.0, "TEST-PROD-03", new Product.Department[0]));
        products.add(Product.of("calculator", 15.0, "TEST-PROD-04", new Product.Department[0]));
        products.add(Product.of("ruler", 2.0, "TEST-PROD-05", new Product.Department[0]));
        products.stream().forEach(product -> this.catalog.save((Product)product));
        int countExpensive = this.catalog.countByPriceGreaterThanEqual(2.99);
        Assertions.assertEquals((int)2, (int)countExpensive, (String)"Expected two products to be more than 3.00");
        Assertions.assertThrows(MappingException.class, () -> this.catalog.countBySurgePriceGreaterThanEqual(2.99));
        Assertions.assertEquals((long)5L, (long)this.catalog.deleteByProductNumLike("TEST-PROD-%"));
    }

    @Assertion(id="133", strategy="Life cycle methods to insert, update, and delete multiple entities.")
    public void testMultipleInsertUpdateDelete() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        Product[] added = this.catalog.addMultiple(Product.of("blueberries", 2.49, "TEST-PROD-95", Product.Department.GROCERY), Product.of("strawberries", 2.29, "TEST-PROD-96", Product.Department.GROCERY), Product.of("raspberries", 2.39, "TEST-PROD-97", Product.Department.GROCERY));
        Assertions.assertEquals((int)3, (int)added.length);
        Assertions.assertEquals((Object)"blueberries", (Object)added[0].getName());
        Assertions.assertEquals((Object)"TEST-PROD-95", (Object)added[0].getProductNum());
        Assertions.assertEquals((double)2.49, (double)added[0].getPrice(), (double)0.001);
        Assertions.assertEquals(Set.of(Product.Department.GROCERY), added[0].getDepartments());
        Product blueberries = added[0];
        Assertions.assertEquals((Object)"strawberries", (Object)added[1].getName());
        Assertions.assertEquals((Object)"TEST-PROD-96", (Object)added[1].getProductNum());
        Assertions.assertEquals((double)2.29, (double)added[1].getPrice(), (double)0.001);
        Assertions.assertEquals(Set.of(Product.Department.GROCERY), added[1].getDepartments());
        Product strawberries = added[1];
        Assertions.assertEquals((Object)"raspberries", (Object)added[2].getName());
        Assertions.assertEquals((Object)"TEST-PROD-97", (Object)added[2].getProductNum());
        Assertions.assertEquals((double)2.39, (double)added[2].getPrice(), (double)0.001);
        Assertions.assertEquals(Set.of(Product.Department.GROCERY), added[2].getDepartments());
        Product raspberries = added[2];
        strawberries.setPrice(1.99);
        raspberries.setPrice(2.34);
        Product[] modified = this.catalog.modifyMultiple(raspberries, strawberries);
        Assertions.assertEquals((int)2, (int)modified.length);
        Assertions.assertEquals((Object)"raspberries", (Object)modified[0].getName());
        Assertions.assertEquals((Object)"TEST-PROD-97", (Object)modified[0].getProductNum());
        Assertions.assertEquals((double)2.34, (double)modified[0].getPrice(), (double)0.001);
        Assertions.assertEquals(Set.of(Product.Department.GROCERY), modified[0].getDepartments());
        raspberries = modified[0];
        Assertions.assertEquals((Object)"strawberries", (Object)modified[1].getName());
        Assertions.assertEquals((Object)"TEST-PROD-96", (Object)modified[1].getProductNum());
        Assertions.assertEquals((double)1.99, (double)modified[1].getPrice(), (double)0.001);
        Assertions.assertEquals(Set.of(Product.Department.GROCERY), modified[1].getDepartments());
        strawberries = modified[1];
        try {
            this.catalog.removeMultiple(Product.of("blackberries", 2.59, "TEST-PROD-98", Product.Department.GROCERY), Product.of("gooseberries", 2.79, "TEST-PROD-99", Product.Department.GROCERY));
            Assertions.fail((String)"OptimisticLockingFailureException must be raised because the entities are not found for deletion.");
        }
        catch (OptimisticLockingFailureException optimisticLockingFailureException) {
            // empty catch block
        }
        this.catalog.removeMultiple(strawberries, blueberries, raspberries);
        Iterable<Product> remaining = this.catalog.findByIdBetween("TEST-PROD-95", "TEST-PROD-99", new Sort[0]);
        Assertions.assertEquals((Object)false, (Object)remaining.iterator().hasNext());
    }

    @Assertion(id="133", strategy="Use a repository method with the Null keyword.")
    public void testNull() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.catalog.save(Product.of("spinach", 2.28, "TEST-PROD-51", Product.Department.GROCERY));
        this.catalog.save(Product.of("broccoli", 2.49, "TEST-PROD-52", Product.Department.GROCERY));
        this.catalog.save(Product.of("rhubarb", null, "TEST-PROD-53", Product.Department.GROCERY));
        this.catalog.save(Product.of("potato", 0.79, "TEST-PROD-54", Product.Department.GROCERY));
        Collection<Product> found = this.catalog.findByPriceNull();
        Assertions.assertEquals((int)1, (int)found.size());
        Assertions.assertEquals((Object)"rhubarb", (Object)found.iterator().next().getName());
        Assertions.assertEquals(List.of("spinach", "potato"), this.catalog.findByPriceNotNullAndPriceLessThanEqual(2.3).map(Product::getName).collect(Collectors.toList()));
        Assertions.assertEquals((long)4L, (long)this.catalog.deleteByProductNumLike("TEST-PROD-%"));
    }

    @Assertion(id="133", strategy="Use a repository method that is annotated with Query and includes JPQL with named parameters.")
    public void testQueryWithNamedParameters() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.catalog.save(Product.of("tape measure", 7.29, "TEST-PROD-61", Product.Department.TOOLS));
        this.catalog.save(Product.of("pry bar", 4.39, "TEST-PROD-62", Product.Department.TOOLS));
        this.catalog.save(Product.of("hammer", 8.59, "TEST-PROD-63", Product.Department.TOOLS));
        this.catalog.save(Product.of("adjustable wrench", 4.99, "TEST-PROD-64", Product.Department.TOOLS));
        this.catalog.save(Product.of("framing square", 9.88, "TEST-PROD-65", Product.Department.TOOLS));
        this.catalog.save(Product.of("rasp", 6.79, "TEST-PROD-66", Product.Department.TOOLS));
        Stream<Product> found = this.catalog.withTaxBetween(0.4, 0.6, 0.08125);
        Assertions.assertEquals(List.of("adjustable wrench", "rasp", "tape measure"), found.map(Product::getName).collect(Collectors.toList()));
        Assertions.assertEquals((long)6L, (long)this.catalog.deleteByProductNumLike("TEST-PROD-%"));
    }

    @Assertion(id="133", strategy="Use a repository method that is annotated with Query and includes JPQL with positional parameters.")
    public void testQueryWithPositionalParameters() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.catalog.save(Product.of("sweater", 23.88, "TEST-PROD-71", Product.Department.CLOTHING));
        this.catalog.save(Product.of("toothpaste", 2.39, "TEST-PROD-72", Product.Department.PHARMACY, Product.Department.GROCERY));
        this.catalog.save(Product.of("chisel", 5.99, "TEST-PROD-73", Product.Department.TOOLS));
        this.catalog.save(Product.of("computer", 1299.5, "TEST-PROD-74", Product.Department.ELECTRONICS, Product.Department.OFFICE));
        this.catalog.save(Product.of("sunblock", 5.98, "TEST-PROD-75", Product.Department.PHARMACY, Product.Department.SPORTING_GOODS, Product.Department.GARDEN));
        this.catalog.save(Product.of("basketball", 14.88, "TEST-PROD-76", Product.Department.SPORTING_GOODS));
        this.catalog.save(Product.of("baseball cap", 12.99, "TEST-PROD-77", Product.Department.SPORTING_GOODS, Product.Department.CLOTHING));
        Streamable<Product> found = this.catalog.findByDepartmentCountAndPriceBelow(2, 100.0);
        Assertions.assertEquals(List.of("baseball cap", "toothpaste"), found.stream().map(Product::getName).collect(Collectors.toList()));
        found = this.catalog.findByDepartmentCountAndPriceBelow(3, 10000.0);
        Assertions.assertEquals(List.of("sunblock"), found.stream().map(Product::getName).collect(Collectors.toList()));
        Assertions.assertEquals((long)7L, (long)this.catalog.deleteByProductNumLike("TEST-PROD-%"));
    }

    @Assertion(id="133", strategy="Insert, update, and delete an entity with a generated version.")
    public void testVersionedInsertUpdateDelete() {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        Product prod1 = this.catalog.add(Product.of("zucchini", 1.49, "TEST-PROD-91", Product.Department.GROCERY));
        Product prod2 = this.catalog.add(Product.of("cucumber", 1.29, "TEST-PROD-92", Product.Department.GROCERY));
        long prod1InitialVersion = prod1.getVersionNum();
        long prod2InitialVersion = prod2.getVersionNum();
        prod1.setPrice(1.59);
        prod1 = this.catalog.modify(prod1);
        prod2.setPrice(1.39);
        prod2 = this.catalog.modify(prod2);
        Assertions.assertNotEquals((long)prod1InitialVersion, (long)prod1.getVersionNum());
        Assertions.assertNotEquals((long)prod2InitialVersion, (long)prod2.getVersionNum());
        long prod1SecondVersion = prod1.getVersionNum();
        prod1.setPrice(1.54);
        prod1 = this.catalog.modify(prod1);
        Assertions.assertNotEquals((long)prod1SecondVersion, (long)prod1.getVersionNum());
        Assertions.assertNotEquals((long)prod1InitialVersion, (long)prod1.getVersionNum());
        prod2.setVersionNum(prod2InitialVersion);
        prod2.setPrice(1.34);
        Assertions.assertEquals(null, (Object)this.catalog.modify(prod2));
        Assertions.assertEquals((Object)true, (Object)this.catalog.remove(prod1));
        Assertions.assertEquals((Object)false, (Object)this.catalog.remove(prod1));
        Assertions.assertEquals((Object)false, (Object)this.catalog.remove(prod2));
        Assertions.assertEquals((long)1L, (long)this.catalog.deleteByProductNumLike("TEST-PROD-%"));
    }
}

