/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.standalone.persistence;

import ee.jakarta.tck.data.standalone.persistence.Product;
import jakarta.data.Sort;
import jakarta.data.Streamable;
import jakarta.data.repository.DataRepository;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Insert;
import jakarta.data.repository.OrderBy;
import jakarta.data.repository.Param;
import jakarta.data.repository.Query;
import jakarta.data.repository.Repository;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;

@Repository
public interface Catalog
extends DataRepository<Product, String> {
    @Insert
    public Product add(Product var1);

    @Insert
    public Product[] addMultiple(Product ... var1);

    @Update
    public Product modify(Product var1);

    @Update
    public Product[] modifyMultiple(Product ... var1);

    @Delete
    public boolean remove(Product var1);

    @Delete
    public void removeMultiple(Product ... var1);

    @Save
    public void save(Product var1);

    public void deleteById(String var1);

    public long deleteByProductNumLike(String var1);

    public int countByPriceGreaterThanEqual(Double var1);

    public int countBySurgePriceGreaterThanEqual(Double var1);

    @Query(value="SELECT p FROM Product p WHERE (SIZE(p.departments) = ?1 AND p.price < ?2) ORDER BY p.name")
    public Streamable<Product> findByDepartmentCountAndPriceBelow(int var1, double var2);

    @OrderBy(value="name")
    public Product[] findByDepartmentsContains(Product.Department var1);

    public LinkedList<Product> findByDepartmentsEmpty();

    public Iterable<Product> findByIdBetween(String var1, String var2, Sort ... var3);

    public List<Product> findByNameLike(String var1);

    public List<Product> findByProductNumLike(String var1);

    @OrderBy(value="price", descending=true)
    public Stream<Product> findByPriceNotNullAndPriceLessThanEqual(double var1);

    public Collection<Product> findByPriceNull();

    public EntityManager getEntityManager();

    default public double sumPrices(Product.Department ... departments) {
        StringBuilder jpql = new StringBuilder("SELECT SUM(o.price) FROM Product o");
        for (int d = 1; d <= departments.length; ++d) {
            jpql.append(d == 1 ? " WHERE " : " OR ");
            jpql.append('?').append(d).append(" MEMBER OF o.departments");
        }
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createQuery(jpql.toString(), Double.class);
        for (int d = 1; d <= departments.length; ++d) {
            query.setParameter(d, (Object)departments[d - 1]);
        }
        return (Double)query.getSingleResult();
    }

    @Query(value="SELECT o FROM Product o WHERE (:rate * o.price <= :max AND :rate * o.price >= :min) ORDER BY o.name")
    public Stream<Product> withTaxBetween(@Param(value="min") double var1, @Param(value="max") double var3, @Param(value="rate") double var5);
}

