/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.utilities;

import ee.jakarta.tck.data.framework.utilities.TestPropertyHandler;
import java.util.logging.Logger;

public enum TestProperty {
    javaHome(true, "java.home", "Path to the java executable used to create the current JVM"),
    javaSpecVer(true, "java.specification.version", "Specification version of the java executable"),
    javaTempDir(true, "java.io.tmpdir", "The path to a temporary directory where a copy of the signature file will be created"),
    javaVer(true, "java.version", "Full version of the java executable"),
    profile(true, "jakarta.tck.profile", "The profile name which is used for reporting and determining the run mode."),
    pollFrequency(false, "jakarta.tck.poll.frequency", "Time in seconds between polls of the repository to verify read-only data was successfully written. Default: 1 second", "1"),
    pollTimeout(false, "jakarta.tck.poll.timeout", "Time in seconds when we will stop polling to verify read-only data was successfully written. Default: 60 seconds", "60"),
    delay(false, "jakarta.tck.consistency.delay", "Time in seconds after verifying read-only data was successfully written to respository for repository to have consistency. Default: none", ""),
    signatureClasspath(false, "signature.sigTestClasspath", "The path to the Jakarta Data API JAR used by your implementation. Required for standalone testing, but optional when testing on a Jakarta EE profile.", ""),
    signatureImageDir(true, "jimage.dir", "The path to a directory that is readable and writable that the signature test will cache Java SE modules as classes");

    private static final Logger log;
    private boolean required;
    private String key;
    private String description;
    private String defaultValue;

    private TestProperty(boolean required, String key, String description) {
        this(required, key, description, null);
    }

    private TestProperty(boolean required, String key, String description, String defaultValue) {
        this.required = required;
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(String expectedValue) {
        return this.getValue().equalsIgnoreCase(expectedValue);
    }

    public boolean isSet() {
        String value = this.getValue(false);
        if (value == null) {
            return false;
        }
        return !value.isBlank() && !value.isEmpty();
    }

    public long getLong() throws IllegalStateException, NumberFormatException {
        return Long.parseLong(this.getValue());
    }

    public int getInt() throws IllegalStateException, NumberFormatException {
        return Integer.parseInt(this.getValue());
    }

    public String getValue() throws IllegalStateException {
        return this.getValue(this.required);
    }

    private String getValue(boolean verify) throws IllegalStateException {
        String value = null;
        log.fine("Searching for property: " + this.key);
        if (value == null) {
            value = System.getProperty(this.key);
            log.fine("Value from system: " + value);
        }
        if (value == null) {
            value = TestPropertyHandler.loadProperties().getProperty(this.key);
            log.fine("Value from resource file: " + value);
        }
        if (value == null) {
            value = this.defaultValue;
            log.fine("Defaulting to value: " + value);
        }
        if (verify && value == null) {
            throw new IllegalStateException("Could not obtain a value for system property: " + this.key);
        }
        return value;
    }

    static {
        log = Logger.getLogger(TestProperty.class.getCanonicalName());
    }
}

