/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.junit.extensions;

import ee.jakarta.tck.data.framework.utilities.TestPropertyUtility;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

public class StandaloneExtension
extends ArquillianExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
InvocationInterceptor,
TestExecutionExceptionHandler {
    private static final Logger log = Logger.getLogger(StandaloneExtension.class.getCanonicalName());

    public void beforeAll(ExtensionContext context) throws Exception {
        if (TestPropertyUtility.isStandalone()) {
            log.info("Running tests in standalone mode, arquillian will not create or deploy archives for test class: " + ((Class)context.getTestClass().get()).getCanonicalName());
            return;
        }
        super.beforeAll(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (TestPropertyUtility.isStandalone()) {
            return;
        }
        super.afterAll(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (TestPropertyUtility.isStandalone()) {
            return;
        }
        super.beforeEach(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (TestPropertyUtility.isStandalone()) {
            return;
        }
        super.afterEach(context);
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (TestPropertyUtility.isStandalone()) {
            invocation.proceed();
            return;
        }
        super.interceptTestTemplateMethod(invocation, invocationContext, extensionContext);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (TestPropertyUtility.isStandalone()) {
            invocation.proceed();
            return;
        }
        super.interceptTestMethod(invocation, invocationContext, extensionContext);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (TestPropertyUtility.isStandalone()) {
            invocation.proceed();
            return;
        }
        super.interceptBeforeEachMethod(invocation, invocationContext, extensionContext);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (TestPropertyUtility.isStandalone()) {
            invocation.proceed();
            return;
        }
        super.interceptAfterEachMethod(invocation, invocationContext, extensionContext);
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (TestPropertyUtility.isStandalone()) {
            invocation.proceed();
            return;
        }
        super.interceptBeforeAllMethod(invocation, invocationContext, extensionContext);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (TestPropertyUtility.isStandalone()) {
            invocation.proceed();
            return;
        }
        super.interceptAfterAllMethod(invocation, invocationContext, extensionContext);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (TestPropertyUtility.isStandalone()) {
            throw throwable;
        }
        super.handleTestExecutionException(context, throwable);
    }
}

