/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.arquillian.extensions;

import ee.jakarta.tck.data.framework.junit.anno.Full;
import ee.jakarta.tck.data.framework.junit.anno.ReadOnlyTest;
import ee.jakarta.tck.data.framework.junit.anno.Signature;
import ee.jakarta.tck.data.framework.junit.anno.Web;
import ee.jakarta.tck.data.framework.read.only.Populator;
import ee.jakarta.tck.data.framework.servlet.TestServlet;
import ee.jakarta.tck.data.framework.signature.DataSignatureTestRunner;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;

public class TCKArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final Logger log = Logger.getLogger(TCKArchiveProcessor.class.getCanonicalName());
    private static final Package servletPackage = TestServlet.class.getPackage();
    private static final Package readOnlyPackage = Populator.class.getPackage();

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        String applicationName;
        String string = applicationName = applicationArchive.getName() == null ? applicationArchive.getId() : applicationArchive.getName();
        if (applicationArchive instanceof ClassContainer) {
            if (testClass.isAnnotationPresent(ReadOnlyTest.class)) {
                log.info("Application Archive [" + applicationName + "] is being appended with packages [" + readOnlyPackage + "]");
                ((ClassContainer)applicationArchive).addPackage(readOnlyPackage);
            }
            if (testClass.isAnnotationPresent(Web.class) || testClass.isAnnotationPresent(Full.class)) {
                log.info("Application Archive [" + applicationName + "] is being appended with packages [" + servletPackage + "]");
                ((ClassContainer)applicationArchive).addPackage(servletPackage);
            }
            TCKArchiveProcessor.appendSignaturePackages(applicationArchive, testClass, applicationName);
        }
    }

    private static void appendSignaturePackages(Archive<?> applicationArchive, TestClass testClass, String applicationName) {
        if (!testClass.isAnnotationPresent(Signature.class)) {
            return;
        }
        boolean isJava21orAbove = Integer.parseInt(System.getProperty("java.specification.version")) >= 21;
        Package signaturePackage = DataSignatureTestRunner.class.getPackage();
        if (applicationArchive instanceof ClassContainer) {
            log.info("Application Archive [" + applicationName + "] is being appended with packages [" + signaturePackage + "]");
            ((ClassContainer)applicationArchive).addPackage(signaturePackage);
            File sigTestDep = ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve("org.netbeans.tools:sigtest-maven-plugin:1.6")).withoutTransitivity()).asSingleFile();
            log.info("Application Archive [" + applicationName + "] is being appended with library " + sigTestDep.getName());
            ((LibraryContainer)applicationArchive).addAsLibrary(sigTestDep);
            log.info("Application Archive [" + applicationName + "] is being appended with resources " + Arrays.asList(DataSignatureTestRunner.SIG_RESOURCES));
            ((ResourceContainer)applicationArchive).addAsResources(signaturePackage, new String[]{"sig-test.map", "sig-test-pkg-list.txt"});
            ((ResourceContainer)applicationArchive).addAsResource(signaturePackage, isJava21orAbove ? "jakarta.data.sig_21" : "jakarta.data.sig_17", signaturePackage.getName().replace(".", "/") + "/jakarta.data.sig");
        }
    }
}

