/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import jakarta.data.Sort;
import jakarta.data.page.PageRequestCursor;
import jakarta.data.page.Pagination;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface PageRequest<T> {
    public static <T> PageRequest<T> of(Class<T> entityClass) {
        return new Pagination(1L, 10, Collections.emptyList(), Mode.OFFSET, null, true);
    }

    public static <T> PageRequest<T> ofPage(long pageNumber) {
        return new Pagination(pageNumber, 10, Collections.emptyList(), Mode.OFFSET, null, true);
    }

    public static <T> PageRequest<T> ofSize(int maxPageSize) {
        return new Pagination(1L, maxPageSize, Collections.emptyList(), Mode.OFFSET, null, true);
    }

    public PageRequest<T> afterKey(Object ... var1);

    public PageRequest<T> beforeKey(Object ... var1);

    public PageRequest<T> afterCursor(Cursor var1);

    public PageRequest<T> beforeCursor(Cursor var1);

    public PageRequest<T> asc(String var1);

    public PageRequest<T> ascIgnoreCase(String var1);

    public PageRequest<T> desc(String var1);

    public PageRequest<T> descIgnoreCase(String var1);

    public boolean equals(Object var1);

    public Optional<Cursor> cursor();

    public Mode mode();

    public long page();

    public int size();

    public boolean requestTotal();

    public List<Sort<? super T>> sorts();

    public PageRequest<T> next();

    public PageRequest<T> previous();

    public PageRequest<T> page(long var1);

    public PageRequest<T> size(int var1);

    public PageRequest<T> sortBy(Iterable<Sort<? super T>> var1);

    public PageRequest<T> sortBy(Sort<? super T> var1);

    public PageRequest<T> sortBy(Sort<? super T> var1, Sort<? super T> var2);

    public PageRequest<T> sortBy(Sort<? super T> var1, Sort<? super T> var2, Sort<? super T> var3);

    public PageRequest<T> sortBy(Sort<? super T> var1, Sort<? super T> var2, Sort<? super T> var3, Sort<? super T> var4);

    public PageRequest<T> sortBy(Sort<? super T> var1, Sort<? super T> var2, Sort<? super T> var3, Sort<? super T> var4, Sort<? super T> var5);

    public PageRequest<T> withoutTotal();

    public PageRequest<T> withTotal();

    public static enum Mode {
        CURSOR_NEXT,
        CURSOR_PREVIOUS,
        OFFSET;

    }

    public static interface Cursor {
        public boolean equals(Object var1);

        public Object get(int var1);

        public int hashCode();

        public int size();

        public List<?> elements();

        public String toString();

        public static Cursor forKey(Object ... key) {
            return new PageRequestCursor(key);
        }
    }
}

