/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import jakarta.data.Sort;
import jakarta.data.page.KeysetCursor;
import jakarta.data.page.PageRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

record Pagination<T>(long page, int size, List<Sort<T>> sorts, PageRequest.Mode mode, PageRequest.Cursor type) implements PageRequest<T>
{
    Pagination {
        if (page < 1L) {
            throw new IllegalArgumentException("pageNumber: " + page);
        }
        if (size < 1) {
            throw new IllegalArgumentException("maxPageSize: " + size);
        }
        if (mode != PageRequest.Mode.OFFSET && (type == null || type.size() == 0)) {
            throw new IllegalArgumentException("No keyset values were provided.");
        }
    }

    @Override
    public PageRequest<T> afterKeyset(Object ... keyset) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_NEXT, new KeysetCursor(keyset));
    }

    @Override
    public PageRequest<T> beforeKeyset(Object ... keyset) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_PREVIOUS, new KeysetCursor(keyset));
    }

    @Override
    public PageRequest<T> afterKeysetCursor(PageRequest.Cursor keysetCursor) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_NEXT, keysetCursor);
    }

    @Override
    public PageRequest<T> beforeKeysetCursor(PageRequest.Cursor keysetCursor) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_PREVIOUS, keysetCursor);
    }

    @Override
    public PageRequest<T> asc(String property) {
        return new Pagination(this.page, this.size, Pagination.combine(this.sorts, Sort.asc(property)), this.mode, this.type);
    }

    @Override
    public PageRequest<T> ascIgnoreCase(String property) {
        return new Pagination(this.page, this.size, Pagination.combine(this.sorts, Sort.ascIgnoreCase(property)), this.mode, this.type);
    }

    private static final <E> List<E> combine(List<E> list, E element) {
        int size = list.size();
        if (size == 0) {
            return List.of(element);
        }
        Object[] array = list.toArray(new Object[size + 1]);
        array[size] = element;
        List<Object> newList = Collections.unmodifiableList(Arrays.asList(array));
        return newList;
    }

    @Override
    public Optional<PageRequest.Cursor> cursor() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public PageRequest<T> desc(String property) {
        return new Pagination(this.page, this.size, Pagination.combine(this.sorts, Sort.desc(property)), this.mode, this.type);
    }

    @Override
    public PageRequest<T> descIgnoreCase(String property) {
        return new Pagination(this.page, this.size, Pagination.combine(this.sorts, Sort.descIgnoreCase(property)), this.mode, this.type);
    }

    @Override
    public PageRequest<T> next() {
        if (this.mode == PageRequest.Mode.OFFSET) {
            return new Pagination<T>(this.page + 1L, this.size, this.sorts, PageRequest.Mode.OFFSET, null);
        }
        throw new UnsupportedOperationException("Not supported for keyset pagination. Instead use afterKeyset or afterKeysetCursor to provide the next keyset values or obtain the nextPageRequest from a KeysetAwareSlice.");
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.mode == PageRequest.Mode.OFFSET ? 100 : 150).append("PageRequest{page=").append(this.page).append(", size=").append(this.size);
        if (this.type != null) {
            s.append(", mode=").append((Object)this.mode).append(", ").append(this.type.size()).append(" keys");
        }
        for (Sort<T> sort : this.sorts) {
            s.append(", ").append(sort.property());
            if (sort.ignoreCase()) {
                s.append(" IGNORE CASE");
            }
            s.append(sort.isAscending() ? " ASC" : " DESC");
        }
        return s.append("}").toString();
    }

    @Override
    public PageRequest<T> page(long pageNumber) {
        return new Pagination<T>(pageNumber, this.size, this.sorts, this.mode, this.type);
    }

    @Override
    public PageRequest<T> size(int maxPageSize) {
        return new Pagination<T>(this.page, maxPageSize, this.sorts, this.mode, this.type);
    }

    @Override
    public PageRequest<T> sortBy(Iterable<Sort<T>> sorts) {
        List<Sort<T>> sortList = sorts instanceof List ? List.copyOf((List)sorts) : (sorts == null ? Collections.emptyList() : StreamSupport.stream(sorts.spliterator(), false).collect(Collectors.toUnmodifiableList()));
        return new Pagination<T>(this.page, this.size, sortList, this.mode, this.type);
    }

    @Override
    public PageRequest<T> sortBy(Sort<T> sort) {
        return new Pagination<T>(this.page, this.size, List.of(sort), this.mode, this.type);
    }

    @Override
    public PageRequest<T> sortBy(Sort<T> sort1, Sort<T> sort2) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2), this.mode, this.type);
    }

    @Override
    public PageRequest<T> sortBy(Sort<T> sort1, Sort<T> sort2, Sort<T> sort3) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2, sort3), this.mode, this.type);
    }

    @Override
    public PageRequest<T> sortBy(Sort<T> sort1, Sort<T> sort2, Sort<T> sort3, Sort<T> sort4) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2, sort3, sort4), this.mode, this.type);
    }

    @Override
    public PageRequest<T> sortBy(Sort<T> sort1, Sort<T> sort2, Sort<T> sort3, Sort<T> sort4, Sort<T> sort5) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2, sort3, sort4, sort5), this.mode, this.type);
    }
}

