/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import jakarta.data.Sort;
import jakarta.data.page.Pagination;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface PageRequest<T> {
    public static <T> PageRequest<T> of(Class<T> entityClass) {
        return new Pagination(1L, 10, Collections.emptyList(), Mode.OFFSET, null);
    }

    public static <T> PageRequest<T> ofPage(long pageNumber) {
        return new Pagination(pageNumber, 10, Collections.emptyList(), Mode.OFFSET, null);
    }

    public static <T> PageRequest<T> ofSize(int maxPageSize) {
        return new Pagination(1L, maxPageSize, Collections.emptyList(), Mode.OFFSET, null);
    }

    public PageRequest<T> afterKeyset(Object ... var1);

    public PageRequest<T> beforeKeyset(Object ... var1);

    public PageRequest<T> afterKeysetCursor(Cursor var1);

    public PageRequest<T> beforeKeysetCursor(Cursor var1);

    public PageRequest<T> asc(String var1);

    public PageRequest<T> ascIgnoreCase(String var1);

    public PageRequest<T> desc(String var1);

    public PageRequest<T> descIgnoreCase(String var1);

    public boolean equals(Object var1);

    public Optional<Cursor> cursor();

    public Mode mode();

    public long page();

    public int size();

    public List<Sort<T>> sorts();

    public PageRequest<T> next();

    public PageRequest<T> page(long var1);

    public PageRequest<T> size(int var1);

    public PageRequest<T> sortBy(Iterable<Sort<T>> var1);

    public PageRequest<T> sortBy(Sort<T> var1);

    public PageRequest<T> sortBy(Sort<T> var1, Sort<T> var2);

    public PageRequest<T> sortBy(Sort<T> var1, Sort<T> var2, Sort<T> var3);

    public PageRequest<T> sortBy(Sort<T> var1, Sort<T> var2, Sort<T> var3, Sort<T> var4);

    public PageRequest<T> sortBy(Sort<T> var1, Sort<T> var2, Sort<T> var3, Sort<T> var4, Sort<T> var5);

    public static enum Mode {
        CURSOR_NEXT,
        CURSOR_PREVIOUS,
        OFFSET;

    }

    public static interface Cursor {
        public boolean equals(Object var1);

        public Object getKeysetElement(int var1);

        public int hashCode();

        public int size();

        public String toString();
    }
}

