/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data;

import jakarta.data.Direction;
import java.util.Objects;

public record Sort(String property, boolean isAscending, boolean ignoreCase) {
    public Sort {
        Objects.requireNonNull(property, "property is required");
    }

    public boolean isDescending() {
        return !this.isAscending;
    }

    public static Sort of(String property, Direction direction, boolean ignoreCase) {
        Objects.requireNonNull(direction, "direction is required");
        return new Sort(property, Direction.ASC.equals((Object)direction), ignoreCase);
    }

    public static Sort asc(String property) {
        return new Sort(property, true, false);
    }

    public static Sort ascIgnoreCase(String property) {
        return new Sort(property, true, true);
    }

    public static Sort desc(String property) {
        return new Sort(property, false, false);
    }

    public static Sort descIgnoreCase(String property) {
        return new Sort(property, false, true);
    }
}

