/*
 * Copyright (c) 2022,2023 Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */
package jakarta.data;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;

/**
 * <p>An interface for sequential streaming of an {@link Iterable}.
 * This is a functional interface and can therefore be used as the assignment target for a lambda expression or method reference.
 * </p>
 *
 * <p>Data is fetched once per <code>Streamable</code> instance;
 * it is not re-fetched with each invocation of {@link #stream()}
 * and {@link #iterator()}.</p>
 *
 * @param <T> the element type.
 */
@FunctionalInterface
public interface Streamable<T> extends Iterable<T> {

    /**
     * Returns a sequential stream of results, which follow the order of the sort criteria if specified.
     *
     * @return a stream of results.
     */
    default Stream<T> stream() {
        return StreamSupport.stream(spliterator(), false);
    }


}
