/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.standalone.persistence.example;

import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.Persistence;
import ee.jakarta.tck.data.framework.junit.anno.Standalone;
import ee.jakarta.tck.data.standalone.persistence.example.Catalog;
import ee.jakarta.tck.data.standalone.persistence.example.Product;
import jakarta.data.exceptions.MappingException;
import jakarta.inject.Inject;
import java.util.ArrayList;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;

@Standalone
@Persistence
public class PersistenceEntityTests {
    @Inject
    Catalog catalog;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Product.class, Catalog.class});
    }

    @Assertion(id="119", strategy="Ensure that this test is only run when provider supports persistence entities")
    public void testNotRunOnNOSQL() {
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(Product.of(1L, "pen", 2.5, 3.5));
        products.add(Product.of(2L, "pencil", 1.25, 2.0));
        products.add(Product.of(3L, "marker", 3.0, 4.0));
        products.add(Product.of(4L, "calculator", 15.0, 20.0));
        products.add(Product.of(5L, "ruler", 2.0, 2.15));
        products.stream().forEach(product -> this.catalog.save((Product)product));
        int countExpensive = this.catalog.countByPriceGreaterThanEqual(2.99);
        Assertions.assertEquals((int)2, (int)countExpensive, (String)"Expected two products to be more than 3.00");
        Assertions.assertThrows(MappingException.class, () -> this.catalog.countBySurgePriceGreaterThanEqual(2.99));
    }
}

