/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.standalone.entity;

import ee.jakarta.tck.data.framework.junit.anno.AnyEntity;
import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.ReadOnlyTest;
import ee.jakarta.tck.data.framework.junit.anno.Standalone;
import ee.jakarta.tck.data.framework.read.only.AsciiCharacter;
import ee.jakarta.tck.data.framework.read.only.AsciiCharacters;
import ee.jakarta.tck.data.framework.read.only.AsciiCharactersPopulator;
import ee.jakarta.tck.data.framework.read.only.NaturalNumber;
import ee.jakarta.tck.data.framework.read.only.NaturalNumbers;
import ee.jakarta.tck.data.framework.read.only.NaturalNumbersPopulator;
import jakarta.data.exceptions.EmptyResultException;
import jakarta.data.exceptions.MappingException;
import jakarta.data.exceptions.NonUniqueResultException;
import jakarta.data.repository.KeysetAwareSlice;
import jakarta.data.repository.Limit;
import jakarta.data.repository.Page;
import jakarta.data.repository.Pageable;
import jakarta.data.repository.Slice;
import jakarta.data.repository.Sort;
import jakarta.data.repository.Streamable;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

@Standalone
@AnyEntity
@ReadOnlyTest
public class EntityTest {
    public static final Logger log = Logger.getLogger(EntityTest.class.getCanonicalName());
    @Inject
    NaturalNumbers numbers;
    @Inject
    AsciiCharacters characters;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{EntityTest.class});
    }

    @BeforeEach
    public void setup() {
        Assertions.assertNotNull((Object)this.numbers);
        NaturalNumbersPopulator.get().populate(this.numbers);
        Assertions.assertNotNull((Object)this.characters);
        AsciiCharactersPopulator.get().populate(this.characters);
    }

    @Assertion(id="136", strategy="Ensures that the prepopulation step for readonly entities was successful")
    public void ensureNaturalNumberPrepopulation() {
        Assertions.assertEquals((long)100L, (long)this.numbers.count());
        Assertions.assertTrue((boolean)this.numbers.findById(0L).isEmpty(), (String)"Zero should not have been in the set of natural numbers.");
        Assertions.assertFalse((boolean)((NaturalNumber)this.numbers.findById(10L).get()).isOdd());
    }

    @Assertion(id="136", strategy="Ensures that multiple readonly entities will be prepopulated before testing")
    public void ensureCharacterPrepopulation() {
        Assertions.assertEquals((int)127, (int)this.characters.countByHexadecimalNotNull());
        Assertions.assertEquals((char)'0', (char)this.characters.findByNumericValue(48).get().getThisCharacter());
        Assertions.assertTrue((boolean)this.characters.findByNumericValue(1).get().isControl());
    }

    @Assertion(id="133", strategy="Request a Page higher than the final Page, expecting an empty Page with 0 results.")
    public void testBeyondFinalPage() {
        Page<AsciiCharacter> page;
        Pageable sixth = Pageable.ofPage((long)6L).sortBy(new Sort[]{Sort.asc((String)"numericValue")}).size(10);
        try {
            page = this.characters.findByNumericValueBetween(48, 90, sixth);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
        Assertions.assertEquals((long)0L, (long)page.stream().count());
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((Object)false, (Object)page.iterator().hasNext());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
    }

    @Assertion(id="133", strategy="Request a Slice higher than the final Slice, expecting an empty Slice with 0 results.")
    public void testBeyondFinalSlice() {
        Pageable sixth = Pageable.ofSize((int)5).sortBy(new Sort[]{Sort.desc((String)"id")}).page(6L);
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, sixth);
        Assertions.assertEquals((int)0, (int)slice.numberOfElements());
        Assertions.assertEquals((long)0L, (long)slice.stream().count());
        Assertions.assertEquals((Object)false, (Object)slice.hasContent());
        Assertions.assertEquals((Object)false, (Object)slice.iterator().hasNext());
    }

    @Assertion(id="133", strategy="Use a repository that inherits from DataRepository and defines all of its own methods.")
    public void testDataRepository() {
        AsciiCharacter del = this.characters.findByIsControlTrueAndNumericValueBetween(33, 127);
        Assertions.assertEquals((int)127, (int)del.getNumericValue());
        Assertions.assertEquals((Object)"7f", (Object)del.getHexadecimal());
        Assertions.assertEquals((Object)true, (Object)del.isControl());
        AsciiCharacter j = this.characters.findByHexadecimalIgnoreCase("6A");
        Assertions.assertEquals((Object)"6a", (Object)j.getHexadecimal());
        Assertions.assertEquals((char)'j', (char)j.getThisCharacter());
        Assertions.assertEquals((int)106, (int)j.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)j.isControl());
        AsciiCharacter d = this.characters.findByNumericValue(100).orElseThrow();
        Assertions.assertEquals((int)100, (int)d.getNumericValue());
        Assertions.assertEquals((char)'d', (char)d.getThisCharacter());
        Assertions.assertEquals((Object)"64", (Object)d.getHexadecimal());
        Assertions.assertEquals((Object)false, (Object)d.isControl());
        Assertions.assertEquals((Object)true, (Object)this.characters.existsByThisCharacter('D'));
    }

    @Assertion(id="133", strategy="Use a repository method with one Sort parameter specifying descending order, and verify all results are returned and are in descending order according to the sort criteria.")
    public void testDescendingSort() {
        Stream<NaturalNumber> stream = this.numbers.findByIdBetween(4L, 10L, Sort.desc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{10L, 9L, 8L, 7L, 6L, 5L, 4L}), (Object)Arrays.toString(stream.map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method that returns a single entity value where no result is found. Expect EmptyResultException.")
    public void testEmptyResultException() {
        try {
            AsciiCharacter ch = this.characters.findByHexadecimalIgnoreCase("2g");
            Assertions.fail((String)("Unexpected result of findByHexadecimalIgnoreCase(2g): " + ch.getHexadecimal()));
        }
        catch (EmptyResultException x) {
            System.out.println("testEmptyResultException expected to catch exception " + x + ". Printing its stack trace:");
            x.printStackTrace(System.out);
        }
    }

    @Assertion(id="133", strategy="Request the last Page of up to 10 results, expecting to find the final 3.")
    public void testFinalPageOfUpTo10() {
        Page<AsciiCharacter> page;
        Pageable fifthPageRequest = Pageable.ofSize((int)10).page(5L).sortBy(new Sort[]{Sort.asc((String)"numericValue")});
        try {
            page = this.characters.findByNumericValueBetween(48, 90, fifthPageRequest);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Iterator it = page.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        AsciiCharacter ch = (AsciiCharacter)it.next();
        Assertions.assertEquals((char)'X', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"58", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)88L, (long)ch.getId());
        Assertions.assertEquals((int)88, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        ch = (AsciiCharacter)it.next();
        Assertions.assertEquals((char)'Y', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"59", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)89L, (long)ch.getId());
        Assertions.assertEquals((int)89, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        ch = (AsciiCharacter)it.next();
        Assertions.assertEquals((char)'Z', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"5a", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)90L, (long)ch.getId());
        Assertions.assertEquals((int)90, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
        Assertions.assertEquals((long)5L, (long)page.pageable().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)3, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
    }

    @Assertion(id="133", strategy="Request the last Slice of up to 5 results, expecting to find the final 2.")
    public void testFinalSliceOfUpTo5() {
        Pageable fifth = Pageable.ofSize((int)5).page(5L).sortBy(new Sort[]{Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, fifth);
        Assertions.assertEquals((Object)true, (Object)slice.hasContent());
        Assertions.assertEquals((long)5L, (long)slice.pageable().page());
        Assertions.assertEquals((int)2, (int)slice.numberOfElements());
        Iterator it = slice.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        NaturalNumber number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)3L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)1L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)true, (Object)number.isOdd());
        Assertions.assertEquals((Short)2, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)2L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)1L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)false, (Object)number.isOdd());
        Assertions.assertEquals((Short)2, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="133", strategy="Request the first KeysetAwareSlice of 6 results, expecting to find all 6, then request the next KeysetAwareSlice and the KeysetAwareSlice after that, expecting to find all results.")
    public void testFirstKeysetAwareSliceOf6AndNextSlices() {
        KeysetAwareSlice<NaturalNumber> slice;
        Pageable first6 = Pageable.ofSize((int)6);
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(7L, first6);
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{49L, 50L, 51L, 52L, 53L, 54L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)6, (int)slice.numberOfElements());
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(7L, slice.nextPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((int)6, (int)slice.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{55L, 56L, 57L, 58L, 59L, 60L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(7L, slice.nextPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{61L, 62L, 63L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)3, (int)slice.numberOfElements());
    }

    @Assertion(id="133", strategy="Request the first Page of 10 results, expecting to find all 10. From the Page, verify the totalElements and totalPages expected.")
    public void testFirstPageOf10() {
        Page<AsciiCharacter> page;
        Pageable first10 = Pageable.ofSize((int)10).sortBy(new Sort[]{Sort.asc((String)"numericValue")});
        try {
            page = this.characters.findByNumericValueBetween(48, 90, first10);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((long)1L, (long)page.pageable().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)10, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
        Assertions.assertEquals((Object)"30:0;31:1;32:2;33:3;34:4;35:5;36:6;37:7;38:8;39:9;", (Object)page.stream().map(c -> c.getHexadecimal() + ":" + c.getThisCharacter() + ";").reduce("", String::concat));
    }

    @Assertion(id="133", strategy="Request the first Slice of 5 results, expecting to find all 5.")
    public void testFirstSliceOf5() {
        Pageable first5 = Pageable.ofSize((int)5).sortBy(new Sort[]{Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, first5);
        Assertions.assertEquals((int)5, (int)slice.numberOfElements());
        Iterator it = slice.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        NaturalNumber number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)79L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)8L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)true, (Object)number.isOdd());
        Assertions.assertEquals((Short)7, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)73L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)71L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)67L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)61L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)7L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)true, (Object)number.isOdd());
        Assertions.assertEquals((Short)6, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="133", strategy="Request a KeysetAwareSlice of 9 results after the keyset of the 20th result, expecting to find the next 9 results. Then request the KeysetAwareSlice before the keyset of the first entry of the slice, expecting to find the previous 9 results. Then request the KeysetAwareSlice after the last entry of the original slice, expecting to find the next 9.")
    public void testKeysetAwareSliceOf9FromCursor() {
        KeysetAwareSlice<NaturalNumber> nextSlice;
        KeysetAwareSlice<NaturalNumber> previousSlice;
        KeysetAwareSlice<NaturalNumber> slice;
        Pageable middle9 = Pageable.ofSize((int)9).sortBy(new Sort[]{Sort.desc((String)"floorOfSquareRoot"), Sort.asc((String)"id")}).afterKeyset(new Object[]{6L, 46L});
        try {
            slice = this.numbers.findByNumTypeAndNumBitsRequiredLessThan(NaturalNumber.NumberType.COMPOSITE, (short)7, middle9);
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{48L, 25L, 26L, 27L, 28L, 30L, 32L, 33L, 34L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)9, (int)slice.numberOfElements());
        try {
            previousSlice = this.numbers.findByNumTypeAndNumBitsRequiredLessThan(NaturalNumber.NumberType.COMPOSITE, (short)7, slice.previousPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{63L, 36L, 38L, 39L, 40L, 42L, 44L, 45L, 46L}), (Object)Arrays.toString(previousSlice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)9, (int)previousSlice.numberOfElements());
        try {
            nextSlice = this.numbers.findByNumTypeAndNumBitsRequiredLessThan(NaturalNumber.NumberType.COMPOSITE, (short)7, slice.nextPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{35L, 16L, 18L, 20L, 21L, 22L, 24L, 9L, 10L}), (Object)Arrays.toString(nextSlice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)9, (int)nextSlice.numberOfElements());
    }

    @Assertion(id="133", strategy="Request a KeysetAwareSlice of results where none match the query, expecting an empty KeysetAwareSlice with 0 results.")
    public void testKeysetAwareSliceOfNothing() {
        KeysetAwareSlice<NaturalNumber> slice;
        Pageable pagination = Pageable.ofSize((int)33).afterKeyset(new Object[]{30L});
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(3L, pagination);
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)false, (Object)slice.hasContent());
        Assertions.assertEquals((int)0, (int)slice.content().size());
        Assertions.assertEquals((int)0, (int)slice.numberOfElements());
    }

    @Assertion(id="133", strategy="Use a repository method with both Sort and Limit, and verify that the Limit caps the number of results and that results are ordered according to the sort criteria.")
    public void testLimit() {
        Collection<NaturalNumber> nums = this.numbers.findByIdGreaterThanEqual(60L, Limit.of((int)10), Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{63L, 62L, 61L, 60L, 80L, 79L, 78L, 77L, 76L, 75L}), (Object)Arrays.toString(nums.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method with both Sort and Limit, where the Limit is a range,  and verify that the Limit range starts in the correct place, caps the number of results,  and that results are ordered according to the sort criteria.")
    public void testLimitedRange() {
        Collection<NaturalNumber> nums = this.numbers.findByIdGreaterThanEqual(40L, Limit.range((long)6L, (long)10L), Sort.asc((String)"numType"), Sort.asc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{61L, 67L, 71L, 73L, 79L}), (Object)Arrays.toString(nums.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method with Limit and verify that the Limit caps the number of results to the amount that is specified.")
    public void testLimitToOneResult() {
        Collection<NaturalNumber> nums = this.numbers.findByIdGreaterThanEqual(80L, Limit.of((int)1), new Sort[0]);
        Iterator<NaturalNumber> it = nums.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        NaturalNumber num = it.next();
        Assertions.assertEquals((Object)true, (Object)(num.getId() >= 80L ? 1 : 0));
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="133", strategy="Use a repository method with two Sort parameters specifying a mixture of ascending and descending order, and verify all results are returned and are ordered according to the sort criteria.")
    public void testMixedSort() {
        NaturalNumber[] nums = this.numbers.findByIdLessThan(15L, Sort.asc((String)"numBitsRequired"), Sort.desc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{1L, 3L, 2L, 7L, 6L, 5L, 4L, 14L, 13L, 12L, 11L, 10L, 9L, 8L}), (Object)Arrays.toString(Stream.of(nums).map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method that ought to return a single entity value but where multiple results are found.Expect NonUniqueResultException.")
    public void testNonUniqueResultException() {
        try {
            AsciiCharacter ch = this.characters.findByIsControlTrueAndNumericValueBetween(10, 15);
            Assertions.fail((String)("Unexpected result of findByIsControlTrueAndNumericValueBetween(10, 15): " + ch.getHexadecimal()));
        }
        catch (NonUniqueResultException x) {
            System.out.println("testNonUniqueResultException expected to catch exception " + x + ". Printing its stack trace:");
            x.printStackTrace(System.out);
        }
    }

    @Assertion(id="133", strategy="Use a repository method with OrderBy (static) and a Sort parameter (dynamic), verfying that all results are returned and are ordered first by the static sort criteria, followed by the dynamic sort criteria when the value(s) being compared by the static criteria match.")
    public void testOrderByHasPrecedenceOverPageableSorts() {
        Pageable pagination = Pageable.ofSize((int)8).sortBy(new Sort[]{Sort.asc((String)"numType"), Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{23L, 19L, 17L, 24L, 22L, 21L, 20L, 18L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        pagination = slice.nextPageable();
        slice = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{16L, 13L, 11L, 15L, 14L, 12L, 10L, 9L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        pagination = slice.nextPageable();
        slice = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{7L, 5L, 8L, 6L, 4L, 1L, 3L, 2L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        pagination = slice.nextPageable();
        if (pagination != null) {
            slice = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination);
            Assertions.assertEquals((Object)false, (Object)slice.hasContent());
        }
    }

    @Assertion(id="133", strategy="Use a repository method with OrderBy (static) and a Pageable with a Sort parameter (dynamic), verfying that all results are returned and are ordered first by the static sort criteria, followed by the dynamic sort criteria when the value(s) being compared by the static criteria match.")
    public void testOrderByHasPrecedenceOverSorts() {
        Stream<NaturalNumber> nums = this.numbers.findByIdBetweenOrderByNumTypeAsc(5L, 24L, Sort.desc((String)"floorOfSquareRoot"), Sort.asc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{17L, 19L, 23L, 11L, 13L, 5L, 7L, 16L, 18L, 20L, 21L, 22L, 24L, 9L, 10L, 12L, 14L, 15L, 6L, 8L}), (Object)Arrays.toString(nums.map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Request a Page of results where none match the query, expecting an empty Page with 0 results.")
    public void testPageOfNothing() {
        Page<AsciiCharacter> page;
        Pageable pagination = Pageable.ofSize((int)6).sortBy(new Sort[]{Sort.asc((String)"id")});
        try {
            page = this.characters.findByNumericValueBetween(150, 160, pagination);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
        Assertions.assertEquals((long)0L, (long)page.stream().count());
        Assertions.assertEquals((int)0, (int)page.content().size());
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((Object)false, (Object)page.iterator().hasNext());
        Assertions.assertEquals((long)0L, (long)page.totalElements());
        Assertions.assertEquals((long)0L, (long)page.totalPages());
    }

    @Assertion(id="133", strategy="Use a repository method that returns a single entity value where a single result is found.")
    public void testSingleEntity() {
        AsciiCharacter ch = this.characters.findByHexadecimalIgnoreCase("2B");
        Assertions.assertEquals((char)'+', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"2b", (Object)ch.getHexadecimal());
        Assertions.assertEquals((int)43, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
    }

    @Assertion(id="133", strategy="Request a Slice of results where none match the query, expecting an empty Slice with 0 results.")
    public void testSliceOfNothing() {
        Pageable pagination = Pageable.ofSize((int)5).sortBy(new Sort[]{Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.COMPOSITE, 1L, pagination);
        Assertions.assertEquals((Object)false, (Object)slice.hasContent());
        Assertions.assertEquals((int)0, (int)slice.content().size());
        Assertions.assertEquals((int)0, (int)slice.numberOfElements());
    }

    @Assertion(id="133", strategy="Use a repository method that returns Streamable and verify the results.")
    public void testStreamable() {
        Streamable<AsciiCharacter> chars = this.characters.findByNumericValueLessThanEqualAndNumericValueGreaterThanEqual(109, 101);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Character[]{Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m')}), (Object)Arrays.toString(chars.stream().map(ch -> Character.valueOf(ch.getThisCharacter())).sorted().toArray()));
        Assertions.assertEquals((int)945, (int)chars.stream().mapToInt(AsciiCharacter::getNumericValue).sum());
        TreeSet sorted = new TreeSet();
        chars.forEach(ch -> sorted.add(ch.getHexadecimal()));
        Assertions.assertEquals(new TreeSet<String>(Set.of("65", "66", "67", "68", "69", "6a", "6b", "6c", "6d")), sorted);
        Streamable<AsciiCharacter> empty = this.characters.findByNumericValueLessThanEqualAndNumericValueGreaterThanEqual(115, 120);
        Assertions.assertEquals((Object)false, (Object)empty.iterator().hasNext());
        Assertions.assertEquals((long)0L, (long)empty.stream().count());
    }

    @Assertion(id="133", strategy="Request the third Page of 10 results, expecting to find all 10. Request the next Page via nextPageable, expecting page number 4 and another 10 results.")
    public void testThirdAndFourthPagesOf10() {
        Page<AsciiCharacter> page;
        Pageable third10 = Pageable.ofPage((long)3L).size(10).sortBy(new Sort[]{Sort.asc((String)"numericValue")});
        try {
            page = this.characters.findByNumericValueBetween(48, 90, third10);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((long)3L, (long)page.pageable().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)10, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
        Assertions.assertEquals((Object)"44:D;45:E;46:F;47:G;48:H;49:I;4a:J;4b:K;4c:L;4d:M;", (Object)page.stream().map(c -> c.getHexadecimal() + ":" + c.getThisCharacter() + ";").reduce("", String::concat));
        Pageable fourth10 = third10.next();
        page = this.characters.findByNumericValueBetween(48, 90, fourth10);
        Assertions.assertEquals((long)4L, (long)page.pageable().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)10, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
        Assertions.assertEquals((Object)"4e:N;4f:O;50:P;51:Q;52:R;53:S;54:T;55:U;56:V;57:W;", (Object)page.stream().map(c -> c.getHexadecimal() + ":" + c.getThisCharacter() + ";").reduce("", String::concat));
    }

    @Assertion(id="133", strategy="Request the third Slice of 5 results, expecting to find all 5. Request the next Slice via nextPageable, expecting page number 4 and another 5 results.")
    public void testThirdAndFourthSlicesOf5() {
        Pageable third5 = Pageable.ofPage((long)3L).size(5).sortBy(new Sort[]{Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, third5);
        Assertions.assertEquals((long)3L, (long)slice.pageable().page());
        Assertions.assertEquals((int)5, (int)slice.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{37L, 31L, 29L, 23L, 19L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Pageable fourth5 = third5.next();
        slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, fourth5);
        Assertions.assertEquals((long)4L, (long)slice.pageable().page());
        Assertions.assertEquals((int)5, (int)slice.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{17L, 13L, 11L, 7L, 5L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method with varargs Sort... specifying a mixture of ascending and descending order, and verify all results are returned and are ordered according to the sort criteria.")
    public void testVarargsSort() {
        ArrayList<NaturalNumber> list = this.numbers.findByIdLessThanEqual(12L, Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"numBitsRequired"), Sort.asc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{2L, 3L, 1L, 8L, 4L, 5L, 6L, 7L, 9L, 10L, 11L, 12L}), (Object)Arrays.toString(list.stream().map(number -> number.getId()).toArray()));
    }
}

