/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.signature;

import ee.jakarta.tck.data.framework.signature.SigTestData;
import ee.jakarta.tck.data.framework.signature.SigTestResult;
import ee.jakarta.tck.data.framework.signature.SignatureTestDriver;
import ee.jakarta.tck.data.framework.signature.SignatureTestDriverFactory;
import ee.jakarta.tck.data.framework.utilities.TestProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;

public abstract class SigTestEE {
    String[] sVehicles;
    protected SignatureTestDriver driver;
    protected SigTestData testInfo;

    protected SignatureTestDriver getSigTestDriver() {
        if (this.driver == null) {
            this.driver = SignatureTestDriverFactory.getInstance("sigtest");
        }
        return this.driver;
    }

    protected String getPackageFile() {
        return this.getSigTestDriver().getPackageFileImpl(this.testInfo.getBinDir());
    }

    protected String getMapFile() {
        return this.getSigTestDriver().getMapFileImpl(this.testInfo.getBinDir());
    }

    protected String getRepositoryDir() {
        return this.getSigTestDriver().getRepositoryDirImpl(this.testInfo.getTSHome());
    }

    protected ArrayList<String> getUnlistedOptionalPackages() {
        return null;
    }

    protected abstract String[] getPackages(String var1);

    protected String[] getClasses(String vehicleName) {
        return new String[0];
    }

    public void setup() {
        try {
            System.out.println("$$$ SigTestEE.setup() called");
            this.testInfo = new SigTestData();
            System.out.println("$$$ SigTestEE.setup() complete");
        }
        catch (Exception e) {
            System.out.println("Unexpected exception " + e.getMessage());
        }
    }

    public void signatureTest() throws Fault {
        System.out.println("$$$ SigTestEE.signatureTest() called");
        SigTestResult results = null;
        String mapFile = this.getMapFile();
        String repositoryDir = this.getRepositoryDir();
        String[] packages = this.getPackages(this.testInfo.getVehicle());
        String[] classes = this.getClasses(this.testInfo.getVehicle());
        String packageFile = this.getPackageFile();
        String testClasspath = this.testInfo.getTestClasspath();
        String optionalPkgToIgnore = this.testInfo.getOptionalTechPackagesToIgnore();
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        Properties sysProps = System.getProperties();
        String version = (String)sysProps.get("java.version");
        if (!version.startsWith("1.")) {
            String jimageDir = TestProperty.signatureImageDir.getValue();
            File f = new File(jimageDir);
            f.mkdirs();
            String javaHome = (String)sysProps.get("java.home");
            System.out.println("Executing JImage");
            try {
                ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/jimage", "extract", "--dir=" + jimageDir, javaHome + "/lib/modules");
                System.out.println(javaHome + "/bin/jimage extract --dir=" + jimageDir + " " + javaHome + "/lib/modules");
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = out.readLine()) != null) {
                    System.out.println(line);
                }
                int rc = proc.waitFor();
                System.out.println("JImage RC = " + rc);
                out.close();
            }
            catch (Exception e) {
                System.out.println("Exception while executing JImage!  Some tests may fail.");
                e.printStackTrace();
            }
        }
        try {
            results = this.getSigTestDriver().executeSigTest(packageFile, mapFile, repositoryDir, packages, classes, testClasspath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            System.out.println(results.toString());
            if (!results.passed()) {
                System.out.println("results.passed() returned false");
                throw new Exception();
            }
            System.out.println("$$$ SigTestEE.signatureTest() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new Fault("SigTestEE.signatureTest() failed!, diffs found");
            }
            System.out.println("Unexpected exception " + e.getMessage());
            throw new Fault("signatureTest failed with an unexpected exception", e);
        }
    }

    public void cleanup() throws Fault {
        System.out.println("$$$ SigTestEE.cleanup() called");
        try {
            this.getSigTestDriver().cleanupImpl();
            System.out.println("$$$ SigTestEE.cleanup() returning");
        }
        catch (Exception e) {
            throw new Fault("Cleanup failed!", e);
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = -1574745208867827913L;
        public Throwable t;

        public Fault(String msg) {
            super(msg);
            System.out.println(msg);
        }

        public Fault(String msg, Throwable t) {
            super(msg);
            this.t = t;
            System.out.println(msg);
            t.printStackTrace();
        }

        public Fault(Throwable t) {
            super(t);
            this.t = t;
        }

        @Override
        public void printStackTrace() {
            if (this.t != null) {
                this.t.printStackTrace();
            } else {
                super.printStackTrace();
            }
        }

        @Override
        public void printStackTrace(PrintStream s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public Throwable getCause() {
            return this.t;
        }

        @Override
        public synchronized Throwable initCause(Throwable cause) {
            if (this.t != null) {
                throw new IllegalStateException("Can't overwrite cause");
            }
            if (!Exception.class.isInstance(cause)) {
                throw new IllegalArgumentException("Cause not permitted");
            }
            this.t = (Exception)cause;
            return this;
        }
    }
}

