/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.arquillian.extensions;

import ee.jakarta.tck.data.framework.junit.anno.Full;
import ee.jakarta.tck.data.framework.junit.anno.ReadOnlyTest;
import ee.jakarta.tck.data.framework.junit.anno.Signature;
import ee.jakarta.tck.data.framework.junit.anno.Web;
import ee.jakarta.tck.data.framework.read.only.Populator;
import ee.jakarta.tck.data.framework.servlet.TestServlet;
import ee.jakarta.tck.data.framework.signature.DataSignatureTestRunner;
import java.util.Arrays;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;

public class TCKArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final Logger log = Logger.getLogger(TCKArchiveProcessor.class.getCanonicalName());
    private static final Package servletPackage = TestServlet.class.getPackage();
    private static final Package signaturePackage = DataSignatureTestRunner.class.getPackage();
    private static final Package readOnlyPackage = Populator.class.getPackage();
    boolean isJava21orAbove = Integer.parseInt(System.getProperty("java.specification.version")) >= 21;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        String applicationName;
        String string = applicationName = applicationArchive.getName() == null ? applicationArchive.getId() : applicationArchive.getName();
        if (applicationArchive instanceof ClassContainer) {
            if (testClass.isAnnotationPresent(ReadOnlyTest.class)) {
                log.info("Application Archive [" + applicationName + "] is being appended with packages [" + readOnlyPackage + "]");
                ((ClassContainer)applicationArchive).addPackage(readOnlyPackage);
            }
            if (testClass.isAnnotationPresent(Web.class) || testClass.isAnnotationPresent(Full.class)) {
                log.info("Application Archive [" + applicationName + "] is being appended with packages [" + servletPackage + "]");
                ((ClassContainer)applicationArchive).addPackage(servletPackage);
            }
            if (testClass.isAnnotationPresent(Signature.class)) {
                log.info("Application Archive [" + applicationName + "] is being appended with packages [" + signaturePackage + ", com.sun.tdk, org.netbeans.apitest]");
                log.info("Application Archive [" + applicationName + "] is being appended with resources " + Arrays.asList(DataSignatureTestRunner.SIG_RESOURCES));
                ((ClassContainer)applicationArchive).addPackage(signaturePackage);
                ((ClassContainer)applicationArchive).addPackages(true, new String[]{"com.sun.tdk", "org.netbeans.apitest"});
                ((ResourceContainer)applicationArchive).addAsResources(signaturePackage, new String[]{"sig-test.map", "sig-test-pkg-list.txt"});
                ((ResourceContainer)applicationArchive).addAsResource(signaturePackage, this.isJava21orAbove ? "jakarta.data.sig_21" : "jakarta.data.sig_17", signaturePackage.getName().replace(".", "/") + "/jakarta.data.sig");
            }
        }
    }
}

