/*
 * Copyright (c) 2022, 2023 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */
package ee.jakarta.tck.data.standalone.example;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.logging.Logger;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

import ee.jakarta.tck.data.framework.junit.anno.AnyEntity;
import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.Standalone;

/**
 * Example test case where we want to run a test both in standalone mode, and in a container.
 * FIXME - This is an example test, remove before the 1.0 release.
 */
@Standalone
@AnyEntity
public class StandaloneExampleTests {
    public static final Logger log = Logger.getLogger(StandaloneExampleTests.class.getCanonicalName());
    
    @Deployment
    public static JavaArchive createDeployment() {
        return ShrinkWrap.create(JavaArchive.class)
                .addClass(StandaloneExampleTests.class);
    }  
    
    @Assertion(id = "26", strategy = "Test runs on client JVM when running in standalone mode, otherwise gets deployed to server and run.")
    public void testStandaloneFunction() {
        assertEquals(1, 1, "One did not equal one.");
    }
}