# Data TCK Signature Tests

This package is inherited from the Platform-TCK (https://github.com/eclipse-ee4j/jakartaee-tck/tree/master/src/com/sun/ts/tests/signaturetest)

The latest signature files are updated in the Jakarta Data TCK Repository 
(data/tck/src/main/resources/ee/jakarta/tck/data/signature) 
generated using sigtest-maven-plugin.jar (version 1.6).

The signature tests are run using the sigtest-maven-plugin.jar and the framework available in this folder.

## For TCK developers

### The configuration

The signature file will be generated by the Data team using the `tck/pom.xml`. 
The pom.xml has a `signature-generation` profile configured for this purpose.
The plugin that generates the signature file has been copied below for reference:


```xml
<plugin>
	<groupId>org.netbeans.tools</groupId>
	<artifactId>sigtest-maven-plugin</artifactId>
	<version>${sigtest.version}</version>
	<executions>
		<execution>
			<id>createSigFile</id>
			<goals>
				<goal>generate</goal>
			</goals>
		</execution>
	</executions>
	<configuration>
		<classes>${project.build.directory}/jakarta-data-api</classes>
		<packages>
			jakarta.data,
			jakarta.data.repository
		</packages>
		<attach>false</attach>
		<sigfile>${project.build.directory}/jakarta.data.sig_${project.version}</sigfile>
	</configuration>
</plugin>
```

- The `classes` configuration points to a location where an earlier plugin has unpacked the api jar from which we are generating the signature file.
- The `packages` configuration specifies the packages we want to generate signatures from. 
- The `attach` configuration specifies that we do not want the plugin to use its default file extension
- The `sigfile` configurations specifies the signature file we want the plugin to generate

### Generating the Signature File

To generate the signature file go to the TCK project:

```sh
cd tck
```

Use Maven to build the TCK and run the custom profile to generate the signature file:

```sh
mvn install -Psignature-generation
```

The signature file will be generated in the `/target/` directory.

The signature file name expected is `jakarta.data.sig_${version}`, where version is the api version from which the signature was generated.

Copy the signature file to the TCK so that it can be used by the test project, and checked into version control.
`src/main/resources/ee/jakarta/tck/data/signature`

## For TCK users

### Running signature tests

#### Standalone Implementation

Signature tests will be automatically run as part of the TCK via the `ee.jakarta.tck.data.standalone.signature` package. 

This package will run the signature tests on the Java SE runtime.
The package runs the signature test using the signaturetest framework from the Platform TCK.

TCK users will need to set a JVM property `-Djimage.dir=<path-your-test-has-access-to>`.
This directory will be populated with class files extracted from the JDK modules.

TCK users will need to set a JVM property `-Dsignature.sigTestClasspath=<path-to-your-api-distribution>:<path-to-jimage-dir>`
This directory will be used to create a virtual classpath for the signature test plugin to use to compare API signatures.

#### Server Implementation

Signature tests will be automatically run as part of the TCK via the `ee.jakarta.tck.data.core.signature` package. 

This package will deploy an application to the Jakarta EE Server. 
The application runs the signature test using the signaturetest framework from the Platform TCK.

Note: The application protocol used for communication between client and application will depend on your Arquillian protocol:
- Core Profile: Should use the REST protocol
- Web Profile: Should use the servlet protocol

TCK users will only need to set a single JVM property `-Djimage.dir=<path-your-app-server-has-access-to>`.
This directory will be populated with class files extracted from the JDK modules.