/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.standalone.signature;

import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.Signature;
import ee.jakarta.tck.data.framework.junit.anno.Standalone;
import ee.jakarta.tck.data.framework.signature.DataSignatureTestRunner;
import ee.jakarta.tck.data.framework.signature.SigTestEE;
import ee.jakarta.tck.data.standalone.signature.SignatureTestBean;
import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Standalone
@Signature
public class SignatureTests {
    private static final Logger log = Logger.getLogger(SignatureTests.class.getCanonicalName());
    @Inject
    SignatureTestBean testBean;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{SignatureTestBean.class});
    }

    @Test
    @Assertion(id="SIGNATURES", strategy="Uses the sigtest-maven-plugin to execute signature tests on a Standalone JVM or on a Jakarta EE Server")
    public void testSignaturesStandalone() throws Exception {
        try {
            if (this.testBean == null && Boolean.getBoolean("jakarta.tck.standalone.test")) {
                log.info("Signature test running in standalone mode");
                DataSignatureTestRunner.assertProjectSetup(true);
                DataSignatureTestRunner runner = new DataSignatureTestRunner();
                runner.signatureTest();
                return;
            }
            log.info("Signature test running on Jakarta EE Server");
            this.testBean.testSignatures();
        }
        catch (SigTestEE.Fault f) {
            Assertions.fail((String)"Signature test failed", (Throwable)f);
        }
    }
}

