/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.signature;

import ee.jakarta.tck.data.framework.signature.PackageList;
import ee.jakarta.tck.data.framework.signature.Recorder;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SigTestRecorder
extends Recorder {
    public SigTestRecorder(String[] args) {
        super(args);
    }

    @Override
    protected String[] createCommandLine(String version, String classpath, String outputFileName, String packageName) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("-static");
        command.add("-debug");
        command.add("-verbose");
        command.add("-classpath");
        command.add(classpath);
        command.add("-FileName");
        try {
            command.add(new File(outputFileName).toURI().toURL().toExternalForm());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        command.add("-package");
        command.add(packageName);
        command.add("-apiVersion");
        command.add(version);
        return command.toArray(new String[command.size()]);
    }

    @Override
    protected void writePackageListFile(String basePackageName, String signatureFile, String packageListFile) throws Exception {
        PackageList packageList = new PackageList(basePackageName, signatureFile, packageListFile);
        packageList.writePkgListFile();
    }

    @Override
    protected void doRecord(String[] commandLine) throws Exception {
        Class<?> batchSetup = Class.forName("com.sun.tdk.signaturetest.Setup");
        Object batchSetupInstance = batchSetup.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method runMethod = batchSetup.getDeclaredMethod("run", String[].class, PrintWriter.class, PrintWriter.class);
        runMethod.invoke(batchSetupInstance, commandLine, new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }
}

