/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.signature;

import ee.jakarta.tck.data.framework.signature.SigTestEE;
import ee.jakarta.tck.data.framework.signature.SigTestResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;

public class DataSignatureTestRunner
extends SigTestEE {
    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());
    public static final String SIG_RESOURCE_PACKAGE = "ee.jakarta.tck.data.framework.signature";
    public static final String SIG_FILE_NAME = "jakarta.data.sig";
    public static final String SIG_MAP_NAME = "sig-test.map";
    public static final String SIG_PKG_NAME = "sig-test-pkg-list.txt";
    public static final String[] SIG_RESOURCES = new String[]{"jakarta.data.sig", "sig-test.map", "sig-test-pkg-list.txt"};

    public DataSignatureTestRunner() {
        this.setup();
    }

    @Override
    protected String[] getPackages(String vehicleName) {
        return new String[]{"jakarta.data", "jakarta.data.repository"};
    }

    protected String getClasspath() {
        String defined = System.getProperty("signature.sigTestClasspath");
        if (defined != null && !defined.isBlank()) {
            return defined;
        }
        String[] classes = new String[]{"jakarta.data.Entity"};
        String[] jdkModules = new String[]{"java.base", "java.rmi", "java.sql", "java.naming"};
        HashSet<String> classPaths = new HashSet<String>();
        for (String c : classes) {
            try {
                URL location;
                Class<?> clazz = Class.forName(c);
                CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                URL uRL = location = codeSource == null ? null : codeSource.getLocation();
                if (codeSource == null || location == null) {
                    this.log.warning(String.format("Could not resolve the the library for %s.", clazz.getName()));
                    continue;
                }
                String path = DataSignatureTestRunner.resolvePath(location);
                if (classPaths.contains(path)) continue;
                classPaths.add(path);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load class " + c + " from application server.");
            }
        }
        File jimageOutput = new File(this.testInfo.getJImageDir());
        for (String module : jdkModules) {
            Path modulePath = Paths.get(jimageOutput.getAbsolutePath(), module);
            if (!Files.isDirectory(modulePath, new LinkOption[0])) {
                throw new RuntimeException("Unable to load JDK module " + module + " from jimage output " + System.lineSeparator() + "Searched in directory: " + modulePath.toString());
            }
            classPaths.add(modulePath.toString());
        }
        return String.join((CharSequence)":", classPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File writeStreamToTempFile(InputStream inputStream, String tempFilePrefix, String tempFileSuffix) throws IOException {
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File file = File.createTempFile(tempFilePrefix, tempFileSuffix);
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file2 = file;
            return file2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File writeStreamToSigFile(InputStream inputStream) throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File sigfile = new File(tmpdir + File.separator + SIG_FILE_NAME);
            if (sigfile.exists()) {
                sigfile.delete();
                this.log.info("Existing signature file deleted to create new one");
            }
            if (!sigfile.createNewFile()) {
                this.log.info("signature file is not created");
            }
            outputStream = new FileOutputStream(sigfile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file = sigfile;
            return file;
        }
    }

    @Override
    public void signatureTest() throws SigTestEE.Fault {
        this.log.info("DataSignatureTestRunner.signatureTest() called");
        SigTestResult results = null;
        String mapFile = null;
        String packageListFile = null;
        String signatureRepositoryDir = null;
        try {
            InputStream inStreamMapfile = DataSignatureTestRunner.class.getClassLoader().getResourceAsStream(SIG_RESOURCE_PACKAGE.replace(".", "/") + "/sig-test.map");
            File mFile = this.writeStreamToTempFile(inStreamMapfile, "sig-test", ".map");
            mapFile = mFile.getCanonicalPath();
            this.log.info("mapFile location is :" + mapFile);
            InputStream inStreamPackageFile = DataSignatureTestRunner.class.getClassLoader().getResourceAsStream(SIG_RESOURCE_PACKAGE.replace(".", "/") + "/sig-test-pkg-list.txt");
            File pFile = this.writeStreamToTempFile(inStreamPackageFile, "sig-test-pkg-list", ".txt");
            packageListFile = pFile.getCanonicalPath();
            this.log.info("packageFile location is :" + packageListFile);
            InputStream inStreamSigFile = DataSignatureTestRunner.class.getClassLoader().getResourceAsStream(SIG_RESOURCE_PACKAGE.replace(".", "/") + "/jakarta.data.sig");
            File sigFile = this.writeStreamToSigFile(inStreamSigFile);
            this.log.info("signature File location is :" + sigFile.getCanonicalPath());
            signatureRepositoryDir = System.getProperty("java.io.tmpdir");
        }
        catch (IOException ex) {
            this.log.info("Exception while creating temp files :" + ex);
        }
        String[] packagesUnderTest = this.getPackages(this.testInfo.getVehicle());
        String[] classesUnderTest = this.getClasses(this.testInfo.getVehicle());
        String optionalPkgToIgnore = this.testInfo.getOptionalTechPackagesToIgnore();
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        String jimageDir = this.testInfo.getJImageDir();
        File f = new File(jimageDir);
        f.mkdirs();
        String javaHome = System.getProperty("java.home");
        this.log.info("Executing JImage");
        try {
            ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/jimage", "extract", "--dir=" + jimageDir, javaHome + "/lib/modules");
            System.out.println(javaHome + "/bin/jimage extract --dir=" + jimageDir + " " + javaHome + "/lib/modules");
            pb.redirectErrorStream(true);
            Process proc = pb.start();
            BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = out.readLine()) != null) {
                this.log.info(line);
            }
            int rc = proc.waitFor();
            this.log.info("JImage RC = " + rc);
            out.close();
        }
        catch (Exception e) {
            this.log.info("Exception while executing JImage!  Some tests may fail.");
            e.printStackTrace();
        }
        String classpath = this.getClasspath();
        try {
            results = this.getSigTestDriver().executeSigTest(packageListFile, mapFile, signatureRepositoryDir, packagesUnderTest, classesUnderTest, classpath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            this.log.info(results.toString());
            if (!results.passed()) {
                this.log.info("results.passed() returned false");
                throw new Exception();
            }
            this.log.info("$$$ DataSignatureTestRunner.signatureTest() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new SigTestEE.Fault("DataSignatureTestRunner.signatureTest() failed!, diffs found");
            }
            this.log.info("Unexpected exception " + e.getMessage());
            throw new SigTestEE.Fault("DataSignatureTestRunner.signatureTest() failed with an unexpected exception", e);
        }
    }

    public static void assertProjectSetup(boolean standalone) {
        Class<?> intf;
        int javaSpecVersion;
        Assertions.assertNotNull((Object)System.getProperty("jimage.dir"), (String)"The system property jimage.dir must be set in order to run the Signature test.");
        if (standalone) {
            Assertions.assertNotNull((Object)System.getProperty("signature.sigTestClasspath"), (String)"The system property signature.sigTestClasspath must be set in order to run the Signature test.");
        }
        Assertions.assertTrue(((javaSpecVersion = Integer.parseInt(System.getProperty("java.specification.version"))) >= 11 ? 1 : 0) != 0, (String)"The signature tests must be run on a JVM using Java 11 or higher.");
        try {
            intf = Class.forName("jdk.internal.vm.annotation.Contended");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load an internal JDK class", e);
        }
        if (!standalone) {
            for (Method m : intf.getDeclaredMethods()) {
                String message;
                try {
                    m.setAccessible(true);
                }
                catch (InaccessibleObjectException ioe) {
                    message = "Tried to call setAccessible on JDK internal method and received an InaccessibleObjectException from the JDK. Give this application (module) access to internal messages using the following JVM properties: --add-exports java.base/jdk.internal.vm.annotation=ALL-UNNAMED --add-opens java.base/jdk.internal.vm.annotation=ALL-UNNAMED";
                    Assertions.fail((String)message, (Throwable)ioe);
                }
                catch (SecurityException se) {
                    message = "Tried to call setAccessible on JDK internal method and received SecurityException from the security manager. Give this application permission to make this method call with the security manager using the following permissions:permission java.lang.RuntimePermission \"accessClassInPackage.jdk.internal\"; permission java.lang.RuntimePermission \"accessClassInPackage.jdk.internal.reflect\"; permission java.lang.RuntimePermission \"accessClassInPackage.jdk.internal.vm.annotation\";";
                    Assertions.fail((String)message, (Throwable)se);
                }
            }
        }
    }

    private static String resolvePath(URL resource) {
        if (resource == null) {
            return null;
        }
        String path = resource.getPath();
        String protocol = resource.getProtocol();
        if ("jar".equals(protocol)) {
            int start;
            int sepIdx = path.lastIndexOf("!/");
            int n = start = path.startsWith("file:") ? 5 : 0;
            if (sepIdx != -1) {
                return path.substring(start, sepIdx);
            }
            return path.substring(start);
        }
        return path;
    }
}

