/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.junit.extensions;

import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.Standalone;
import java.lang.reflect.Method;
import org.junit.jupiter.api.DisplayNameGenerator;

public class AssertionNameGenerator
extends DisplayNameGenerator.Simple
implements DisplayNameGenerator {
    public static final String platformProperty = "jakarta.tck.platform";

    public String generateDisplayNameForClass(Class<?> testClass) {
        String platform = System.getProperty(platformProperty);
        if (platform != null && !platform.isEmpty()) {
            return testClass.getSimpleName() + "#" + platform.replace("#", "");
        }
        boolean isStandalone = Boolean.getBoolean("jakarta.tck.standalone.test");
        if (testClass.isAnnotationPresent(Standalone.class) && !isStandalone) {
            return testClass.getSimpleName() + "#Deployed";
        }
        return super.generateDisplayNameForClass(testClass);
    }

    public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
        String platform = System.getProperty(platformProperty);
        if (platform != null && !platform.isEmpty()) {
            return nestedClass.getSimpleName() + "#" + platform.replace("#", "");
        }
        boolean isStandalone = Boolean.getBoolean("jakarta.tck.standalone.test");
        if (nestedClass.isAnnotationPresent(Standalone.class) && !isStandalone) {
            return nestedClass.getSimpleName() + "#Deployed";
        }
        return super.generateDisplayNameForNestedClass(nestedClass);
    }

    public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
        Assertion instance = testMethod.getAnnotation(Assertion.class);
        if (instance != null) {
            return testMethod.getName() + "@Assertion.id:" + instance.id();
        }
        return super.generateDisplayNameForMethod(testClass, testMethod);
    }
}

