/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.junit.extensions;

import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class AssertionExtension
implements TestWatcher {
    private static final Logger log = Logger.getLogger(AssertionExtension.class.getCanonicalName());
    private static final String nl = System.lineSeparator();

    public void testFailed(ExtensionContext context, Throwable cause) {
        Method testMethod = context.getRequiredTestMethod();
        Assertion instance = testMethod.getAnnotation(Assertion.class);
        if (instance != null) {
            log.warning(testMethod.getName() + " failed " + nl + " @Assertion.id:" + instance.id() + nl + " @Assertion.strategy: " + instance.strategy());
        }
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        Method testMethod = context.getRequiredTestMethod();
        Assertion instance = testMethod.getAnnotation(Assertion.class);
        if (instance != null) {
            log.warning(testMethod.getName() + " was aborted " + nl + " @Assertion.id:" + instance.id() + nl + " @Assertion.strategy: " + instance.strategy());
        }
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        Method testMethod = context.getRequiredTestMethod();
        Assertion instance = testMethod.getAnnotation(Assertion.class);
        if (instance != null) {
            log.warning(testMethod.getName() + " is disabled" + nl + " @Assertion.id:" + instance.id() + nl + " @Assertion.strategy: " + instance.strategy() + nl + " Reason:" + reason.get());
        }
    }
}

