/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.arquillian.extensions;

import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.Full;
import ee.jakarta.tck.data.framework.junit.anno.Signature;
import ee.jakarta.tck.data.framework.junit.anno.Web;
import ee.jakarta.tck.data.framework.junit.extensions.AssertionExtension;
import ee.jakarta.tck.data.framework.servlet.TestServlet;
import ee.jakarta.tck.data.framework.signature.DataSignatureTestRunner;
import java.util.Arrays;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;

public class TCKArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final Logger log = Logger.getLogger(TCKArchiveProcessor.class.getCanonicalName());
    private static final Package annoPackage = Assertion.class.getPackage();
    private static final Package extensionPackage = AssertionExtension.class.getPackage();
    private static final Package servletPackage = TestServlet.class.getPackage();
    private static final Package signaturePackage = DataSignatureTestRunner.class.getPackage();

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        String applicationName;
        String string = applicationName = applicationArchive.getName() == null ? applicationArchive.getId() : applicationArchive.getName();
        if (applicationArchive instanceof ClassContainer) {
            log.info("Application Archive [" + applicationName + "] is being appended with packages [" + annoPackage + " ," + extensionPackage + "]");
            ((ClassContainer)applicationArchive).addPackages(false, new Package[]{annoPackage, extensionPackage});
            if (testClass.isAnnotationPresent(Web.class) || testClass.isAnnotationPresent(Full.class)) {
                log.info("Application Archive [" + applicationName + "] is being appended with packages [" + servletPackage + "]");
                ((ClassContainer)applicationArchive).addPackage(servletPackage);
            }
            if (testClass.isAnnotationPresent(Signature.class)) {
                log.info("Application Archive [" + applicationName + "] is being appended with packages [" + signaturePackage + "]");
                log.info("Application Archive [" + applicationName + "] is being appended with resources " + Arrays.asList(DataSignatureTestRunner.SIG_RESOURCES));
                ((ClassContainer)applicationArchive).addPackage(signaturePackage);
                ((ResourceContainer)applicationArchive).addAsResources(signaturePackage, DataSignatureTestRunner.SIG_RESOURCES);
            }
        }
    }
}

