/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.standalone.persistence;

import jakarta.persistence.Basic;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.Collections;
import java.util.Set;

@Entity
public class Product {
    @ElementCollection
    private Set<Department> departments;
    @Basic(optional=false)
    private String name;
    private Double price;
    @Basic(optional=false)
    @Id
    private String productNum;
    @Transient
    private Double surgePrice;
    @Version
    private long versionNum;

    public static Product of(String name, Double price, String productNum, Department ... departments) {
        return new Product(name, price, price, productNum, departments);
    }

    private Product(String name, Double price, Double surgePrice, String productNum, Department ... departments) {
        this.productNum = productNum;
        this.name = name;
        this.price = price;
        this.surgePrice = surgePrice;
        this.departments = departments == null ? Collections.emptySet() : Set.of(departments);
    }

    public Product() {
    }

    public Set<Department> getDepartments() {
        return this.departments;
    }

    public void setDepartments(Set<Department> departments) {
        this.departments = departments;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public String getProductNum() {
        return this.productNum;
    }

    public void setProductNum(String productNum) {
        this.productNum = productNum;
    }

    public long getVersionNum() {
        return this.versionNum;
    }

    public Double getSurgePrice() {
        return this.surgePrice;
    }

    public void setSurgePrice(Double surgePrice) {
        this.surgePrice = surgePrice;
    }

    public void setVersionNum(long versionNum) {
        this.versionNum = versionNum;
    }

    public static enum Department {
        APPLIANCES,
        AUTOMOTIVE,
        CLOTHING,
        ELECTRONICS,
        FURNITURE,
        GARDEN,
        GROCERY,
        OFFICE,
        PHARMACY,
        SPORTING_GOODS,
        TOOLS;

    }
}

