/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.standalone.entity;

import ee.jakarta.tck.data.framework.junit.anno.AnyEntity;
import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.ReadOnlyTest;
import ee.jakarta.tck.data.framework.junit.anno.Standalone;
import ee.jakarta.tck.data.framework.read.only.AsciiCharacter;
import ee.jakarta.tck.data.framework.read.only.AsciiCharacter_;
import ee.jakarta.tck.data.framework.read.only.AsciiCharacters;
import ee.jakarta.tck.data.framework.read.only.AsciiCharactersPopulator;
import ee.jakarta.tck.data.framework.read.only.NaturalNumber;
import ee.jakarta.tck.data.framework.read.only.NaturalNumbers;
import ee.jakarta.tck.data.framework.read.only.NaturalNumbersPopulator;
import ee.jakarta.tck.data.framework.read.only.PositiveIntegers;
import jakarta.data.Limit;
import jakarta.data.Sort;
import jakarta.data.Streamable;
import jakarta.data.exceptions.EmptyResultException;
import jakarta.data.exceptions.MappingException;
import jakarta.data.exceptions.NonUniqueResultException;
import jakarta.data.page.KeysetAwarePage;
import jakarta.data.page.KeysetAwareSlice;
import jakarta.data.page.Page;
import jakarta.data.page.Pageable;
import jakarta.data.page.Slice;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

@Standalone
@AnyEntity
@ReadOnlyTest
public class EntityTests {
    public static final Logger log = Logger.getLogger(EntityTests.class.getCanonicalName());
    @Inject
    NaturalNumbers numbers;
    @Inject
    PositiveIntegers positives;
    @Inject
    AsciiCharacters characters;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{EntityTests.class});
    }

    @BeforeEach
    public void setup() {
        Assertions.assertNotNull((Object)this.numbers);
        NaturalNumbersPopulator.get().populate(this.numbers);
        Assertions.assertNotNull((Object)this.characters);
        AsciiCharactersPopulator.get().populate(this.characters);
    }

    @Assertion(id="136", strategy="Ensures that the prepopulation step for readonly entities was successful")
    public void ensureNaturalNumberPrepopulation() {
        Assertions.assertEquals((long)100L, (long)this.numbers.count());
        Assertions.assertTrue((boolean)this.numbers.findById(0L).isEmpty(), (String)"Zero should not have been in the set of natural numbers.");
        Assertions.assertFalse((boolean)((NaturalNumber)this.numbers.findById(10L).get()).isOdd());
    }

    @Assertion(id="136", strategy="Ensures that multiple readonly entities will be prepopulated before testing")
    public void ensureCharacterPrepopulation() {
        Assertions.assertEquals((int)127, (int)this.characters.countByHexadecimalNotNull());
        Assertions.assertEquals((char)'0', (char)this.characters.findByNumericValue(48).get().getThisCharacter());
        Assertions.assertTrue((boolean)this.characters.findByNumericValue(1).get().isControl());
    }

    @Assertion(id="133", strategy="Use a repository that inherits from BasicRepository and adds some methods of its own. Use both built-in methods and the additional methods.")
    public void testBasicRepository() {
        Assertions.assertEquals((Object)false, (Object)this.numbers.existsById(0L));
        Assertions.assertEquals((Object)true, (Object)this.numbers.existsById(80L));
        Stream found = this.numbers.findByIdIn(List.of(Long.valueOf(70L), Long.valueOf(40L), Long.valueOf(-20L), Long.valueOf(10L)));
        Assertions.assertEquals(List.of(Long.valueOf(10L), Long.valueOf(40L), Long.valueOf(70L)), found.map(NaturalNumber::getId).sorted().collect(Collectors.toList()));
        found = this.numbers.findByIdBetween(50L, 59L, Sort.asc((String)"numType"));
        List list = found.map(NaturalNumber::getId).collect(Collectors.toList());
        Assertions.assertEquals(Set.of(Long.valueOf(53L), Long.valueOf(59L)), new TreeSet(list.subList(0, 2)));
        Assertions.assertEquals(Set.of(Long.valueOf(50L), Long.valueOf(51L), Long.valueOf(52L), Long.valueOf(54L), Long.valueOf(55L), Long.valueOf(56L), Long.valueOf(57L), Long.valueOf(58L)), new TreeSet(list.subList(2, 10)));
    }

    @Assertion(id="133", strategy="Request a Page higher than the final Page, expecting an empty Page with 0 results.")
    public void testBeyondFinalPage() {
        Page<AsciiCharacter> page;
        Pageable sixth = Pageable.ofPage((long)6L).sortBy(new Sort[]{Sort.asc((String)"numericValue")}).size(10);
        try {
            page = this.characters.findByNumericValueBetween(48, 90, sixth);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
        Assertions.assertEquals((long)0L, (long)page.stream().count());
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((Object)false, (Object)page.iterator().hasNext());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
    }

    @Assertion(id="133", strategy="Request a Slice higher than the final Slice, expecting an empty Slice with 0 results.")
    public void testBeyondFinalSlice() {
        Pageable sixth = Pageable.ofSize((int)5).sortBy(new Sort[]{Sort.desc((String)"id")}).page(6L);
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, sixth);
        Assertions.assertEquals((int)0, (int)slice.numberOfElements());
        Assertions.assertEquals((long)0L, (long)slice.stream().count());
        Assertions.assertEquals((Object)false, (Object)slice.hasContent());
        Assertions.assertEquals((Object)false, (Object)slice.iterator().hasNext());
    }

    @Assertion(id="133", strategy="Use a repository that inherits some if its methods from another interface.")
    public void testCommonInterfaceQueries() {
        Assertions.assertEquals(List.of(Character.valueOf('d'), Character.valueOf('c'), Character.valueOf('b'), Character.valueOf('a')), this.characters.findByIdBetween(97L, 100L, Sort.desc((String)"thisCharacter")).map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
        Assertions.assertEquals(List.of(Long.valueOf(87L), Long.valueOf(88L), Long.valueOf(89L), Long.valueOf(90L)), this.numbers.findByIdBetween(87L, 90L, Sort.asc((String)"id")).map(NaturalNumber::getId).collect(Collectors.toList()));
        Assertions.assertEquals(List.of(Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H')), this.characters.findByIdGreaterThanEqual(68L, Limit.of((int)5), new Sort[]{Sort.asc((String)"numericValue"), Sort.asc((String)"id")}).stream().map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
        Assertions.assertEquals(List.of(Long.valueOf(71L), Long.valueOf(73L), Long.valueOf(79L), Long.valueOf(83L), Long.valueOf(89L)), this.numbers.findByIdGreaterThanEqual(68L, Limit.of((int)5), new Sort[]{Sort.asc((String)"numType"), Sort.asc((String)"id")}).stream().map(NaturalNumber::getId).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method with Contains to query for a substring of a String attribute.")
    public void testContainsInString() {
        Collection<AsciiCharacter> found = this.characters.findByHexadecimalContainsAndIsControlNot("4", true);
        Assertions.assertEquals(List.of("24", "34", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "54", "64", "74"), found.stream().map(AsciiCharacter::getHexadecimal).sorted().toList());
    }

    @Assertion(id="133", strategy="Use a repository that inherits from DataRepository and defines all of its own methods.")
    public void testDataRepository() {
        AsciiCharacter del = this.characters.findByIsControlTrueAndNumericValueBetween(33, 127);
        Assertions.assertEquals((int)127, (int)del.getNumericValue());
        Assertions.assertEquals((Object)"7f", (Object)del.getHexadecimal());
        Assertions.assertEquals((Object)true, (Object)del.isControl());
        AsciiCharacter j = this.characters.findByHexadecimalIgnoreCase("6A");
        Assertions.assertEquals((Object)"6a", (Object)j.getHexadecimal());
        Assertions.assertEquals((char)'j', (char)j.getThisCharacter());
        Assertions.assertEquals((int)106, (int)j.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)j.isControl());
        AsciiCharacter d = this.characters.findByNumericValue(100).orElseThrow();
        Assertions.assertEquals((int)100, (int)d.getNumericValue());
        Assertions.assertEquals((char)'d', (char)d.getThisCharacter());
        Assertions.assertEquals((Object)"64", (Object)d.getHexadecimal());
        Assertions.assertEquals((Object)false, (Object)d.isControl());
        Assertions.assertEquals((Object)true, (Object)this.characters.existsByThisCharacter('D'));
    }

    @Assertion(id="133", strategy="Use a default method from a repository interface where the default method invokes other repository methods.")
    public void testDefaultMethod() {
        Assertions.assertEquals(List.of(Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d')), this.characters.retrieveAlphaNumericIn(87L, 100L).map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method with one Sort parameter specifying descending order, and verify all results are returned and are in descending order according to the sort criteria.")
    public void testDescendingSort() {
        Stream stream = this.numbers.findByIdBetween(4L, 10L, Sort.desc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{10L, 9L, 8L, 7L, 6L, 5L, 4L}), (Object)Arrays.toString(stream.map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method that returns a single entity value where no result is found. Expect EmptyResultException.")
    public void testEmptyResultException() {
        try {
            AsciiCharacter ch = this.characters.findByHexadecimalIgnoreCase("2g");
            Assertions.fail((String)("Unexpected result of findByHexadecimalIgnoreCase(2g): " + ch.getHexadecimal()));
        }
        catch (EmptyResultException x) {
            System.out.println("testEmptyResultException expected to catch exception " + x + ". Printing its stack trace:");
            x.printStackTrace(System.out);
        }
    }

    @Assertion(id="133", strategy="Use a repository method with the False keyword.")
    public void testFalse() {
        Streamable<NaturalNumber> even = this.positives.findByIsOddFalseAndIdBetween(50L, 60L);
        Assertions.assertEquals((long)6L, (long)even.stream().count());
        Assertions.assertEquals(List.of(Long.valueOf(50L), Long.valueOf(52L), Long.valueOf(54L), Long.valueOf(56L), Long.valueOf(58L), Long.valueOf(60L)), even.stream().map(NaturalNumber::getId).sorted().collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Request the last Page of up to 10 results, expecting to find the final 3.")
    public void testFinalPageOfUpTo10() {
        Page<AsciiCharacter> page;
        Pageable fifthPageRequest = Pageable.ofSize((int)10).page(5L).sortBy(new Sort[]{Sort.asc((String)"numericValue")});
        try {
            page = this.characters.findByNumericValueBetween(48, 90, fifthPageRequest);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Iterator it = page.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        AsciiCharacter ch = (AsciiCharacter)it.next();
        Assertions.assertEquals((char)'X', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"58", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)88L, (long)ch.getId());
        Assertions.assertEquals((int)88, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        ch = (AsciiCharacter)it.next();
        Assertions.assertEquals((char)'Y', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"59", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)89L, (long)ch.getId());
        Assertions.assertEquals((int)89, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        ch = (AsciiCharacter)it.next();
        Assertions.assertEquals((char)'Z', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"5a", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)90L, (long)ch.getId());
        Assertions.assertEquals((int)90, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
        Assertions.assertEquals((long)5L, (long)page.pageable().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)3, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
    }

    @Assertion(id="133", strategy="Request the last Slice of up to 5 results, expecting to find the final 2.")
    public void testFinalSliceOfUpTo5() {
        Pageable fifth = Pageable.ofSize((int)5).page(5L).sortBy(new Sort[]{Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, fifth);
        Assertions.assertEquals((Object)true, (Object)slice.hasContent());
        Assertions.assertEquals((long)5L, (long)slice.pageable().page());
        Assertions.assertEquals((int)2, (int)slice.numberOfElements());
        Iterator it = slice.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        NaturalNumber number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)3L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)1L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)true, (Object)number.isOdd());
        Assertions.assertEquals((Short)2, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)2L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)1L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)false, (Object)number.isOdd());
        Assertions.assertEquals((Short)2, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="133", strategy="Use the findAll method of a repository that inherits from PageableRepository to request a Page 2 of size 12, specifying a Pageable that requires a mixture of ascending and descending sort. Verify the page contains all 12 expected entities, sorted according to the mixture of ascending and descending sort orders specified.")
    public void testFindAllWithPagination() {
        Pageable page2request = Pageable.ofPage((long)2L).size(12).sortBy(new Sort[]{Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"id")});
        Page page2 = this.positives.findAll(page2request);
        Assertions.assertEquals((int)12, (int)page2.numberOfElements());
        Assertions.assertEquals((long)2L, (long)page2.pageable().page());
        Assertions.assertEquals(List.of(11L, 10L, 9L, 24L, 23L, 22L, 21L, 20L, 19L, 18L, 17L, 16L), page2.stream().map(n -> n.getId()).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method with findFirstBy that returns the first entity value where multiple results would otherwise be found.")
    public void testFindFirst() {
        Optional<AsciiCharacter> none = this.characters.findFirstByHexadecimalStartsWithAndIsControlOrderByIdAsc("h", false);
        Assertions.assertEquals((Object)true, (Object)none.isEmpty());
        AsciiCharacter ch = this.characters.findFirstByHexadecimalStartsWithAndIsControlOrderByIdAsc("4", false).orElseThrow();
        Assertions.assertEquals((char)'@', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"40", (Object)ch.getHexadecimal());
        Assertions.assertEquals((int)64, (int)ch.getNumericValue());
    }

    @Assertion(id="133", strategy="Use a repository method with findFirst3By that returns the first 3 results.")
    public void testFindFirst3() {
        AsciiCharacter[] found = this.characters.findFirst3ByNumericValueGreaterThanEqualAndHexadecimalEndsWith(40L, "4", Sort.asc((String)"numericValue"));
        Assertions.assertEquals((int)3, (int)found.length);
        Assertions.assertEquals((char)'4', (char)found[0].getThisCharacter());
        Assertions.assertEquals((char)'D', (char)found[1].getThisCharacter());
        Assertions.assertEquals((char)'T', (char)found[2].getThisCharacter());
    }

    @Assertion(id="133", strategy="Find a list of entities, querying by entity attributes with names that match the method parameter names, with results capped by a Limit parameter and sorted according to a variable arguments Sort parameter.")
    public void testFindList() {
        List<NaturalNumber> oddCompositeNumbers = this.positives.findOdd(true, NaturalNumber.NumberType.COMPOSITE, Limit.of((int)10), Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"numBitsRequired"), Sort.asc((String)"id"));
        Assertions.assertEquals(List.of(Long.valueOf(9L), Long.valueOf(15L), Long.valueOf(21L), Long.valueOf(33L), Long.valueOf(35L), Long.valueOf(25L), Long.valueOf(27L), Long.valueOf(39L), Long.valueOf(45L), Long.valueOf(49L)), oddCompositeNumbers.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        List<NaturalNumber> evenPrimeNumbers = this.positives.findOdd(false, NaturalNumber.NumberType.PRIME, Limit.of((int)9), new Sort[0]);
        Assertions.assertEquals((int)1, (int)evenPrimeNumbers.size());
        NaturalNumber num = evenPrimeNumbers.get(0);
        Assertions.assertEquals((long)2L, (long)num.getId());
        Assertions.assertEquals((long)1L, (long)num.getFloorOfSquareRoot());
        Assertions.assertEquals((Short)2, (Short)num.getNumBitsRequired());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)num.getNumType()));
        Assertions.assertEquals((Object)false, (Object)num.isOdd());
    }

    @Assertion(id="133", strategy="Find a single entity, querying by entity attributes with names that match the method parameter names.")
    public void testFindOne() {
        AsciiCharacter j = this.characters.find('j');
        Assertions.assertEquals((Object)"6a", (Object)j.getHexadecimal());
        Assertions.assertEquals((long)106L, (long)j.getId());
        Assertions.assertEquals((int)106, (int)j.getNumericValue());
        Assertions.assertEquals((char)'j', (char)j.getThisCharacter());
    }

    @Assertion(id="133", strategy="Find a single entity that might or might not exist, querying by entity attributes with names that match the method parameter names.")
    public void testFindOptional() {
        NaturalNumber num = this.positives.findNumber(67L).orElseThrow();
        Assertions.assertEquals((long)67L, (long)num.getId());
        Assertions.assertEquals((long)8L, (long)num.getFloorOfSquareRoot());
        Assertions.assertEquals((Short)7, (Short)num.getNumBitsRequired());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)num.getNumType()));
        Assertions.assertEquals((Object)true, (Object)num.isOdd());
        Optional<NaturalNumber> opt = this.positives.findNumber(-40L);
        Assertions.assertEquals((Object)false, (Object)opt.isPresent());
    }

    @Assertion(id="133", strategy="Find a page of entities, with entity attributes identified by the parameter names and matching the parameter values.")
    public void testFindPage() {
        Pageable page1Request = Pageable.ofSize((int)7).sortBy(new Sort[]{Sort.desc((String)"id")});
        Page<NaturalNumber> page1 = this.positives.findMatching(9L, (short)7, NaturalNumber.NumberType.COMPOSITE, page1Request);
        Assertions.assertEquals(List.of(Long.valueOf(99L), Long.valueOf(98L), Long.valueOf(96L), Long.valueOf(95L), Long.valueOf(94L), Long.valueOf(93L), Long.valueOf(92L)), page1.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        Page<NaturalNumber> page2 = this.positives.findMatching(9L, (short)7, NaturalNumber.NumberType.COMPOSITE, page1.nextPageable());
        Assertions.assertEquals(List.of(Long.valueOf(91L), Long.valueOf(90L), Long.valueOf(88L), Long.valueOf(87L), Long.valueOf(86L), Long.valueOf(85L), Long.valueOf(84L)), page2.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        Page<NaturalNumber> page3 = this.positives.findMatching(9L, (short)7, NaturalNumber.NumberType.COMPOSITE, page2.nextPageable());
        Assertions.assertEquals(List.of(Long.valueOf(82L), Long.valueOf(81L)), page3.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Request the first KeysetAwarePage of 8 results, expecting to find all 8, then request the next KeysetAwarePage and the KeysetAwarePage after that, expecting to find all results.")
    public void testFirstKeysetAwarePageOf8AndNextPages() {
        KeysetAwarePage<NaturalNumber> page;
        Pageable first8 = Pageable.ofSize((int)8).sortBy(new Sort[]{Sort.asc((String)"id")});
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByBitsRequiredDesc(4L, 33L, first8);
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((int)8, (int)page.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByBitsRequiredDesc(4L, 33L, page.nextPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{9L, 10L, 11L, 12L, 13L, 14L, 15L, 4L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)8, (int)page.numberOfElements());
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByBitsRequiredDesc(4L, 33L, page.nextPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((int)7, (int)page.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{5L, 6L, 7L, 8L, 1L, 2L, 3L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Request the first KeysetAwareSlice of 6 results, expecting to find all 6, then request the next KeysetAwareSlice and the KeysetAwareSlice after that, expecting to find all results.")
    public void testFirstKeysetAwareSliceOf6AndNextSlices() {
        KeysetAwareSlice<NaturalNumber> slice;
        Pageable first6 = Pageable.ofSize((int)6);
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(7L, first6);
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{49L, 50L, 51L, 52L, 53L, 54L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)6, (int)slice.numberOfElements());
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(7L, slice.nextPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((int)6, (int)slice.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{55L, 56L, 57L, 58L, 59L, 60L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(7L, slice.nextPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{61L, 62L, 63L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)3, (int)slice.numberOfElements());
    }

    @Assertion(id="133", strategy="Request the first Page of 10 results, expecting to find all 10. From the Page, verify the totalElements and totalPages expected.")
    public void testFirstPageOf10() {
        Page<AsciiCharacter> page;
        Pageable first10 = Pageable.ofSize((int)10).sortBy(new Sort[]{Sort.asc((String)"numericValue")});
        try {
            page = this.characters.findByNumericValueBetween(48, 90, first10);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((long)1L, (long)page.pageable().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)10, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
        Assertions.assertEquals((Object)"30:0;31:1;32:2;33:3;34:4;35:5;36:6;37:7;38:8;39:9;", (Object)page.stream().map(c -> c.getHexadecimal() + ":" + c.getThisCharacter() + ";").reduce("", String::concat));
    }

    @Assertion(id="133", strategy="Request the first Slice of 5 results, expecting to find all 5.")
    public void testFirstSliceOf5() {
        Pageable first5 = Pageable.ofSize((int)5).sortBy(new Sort[]{Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, first5);
        Assertions.assertEquals((int)5, (int)slice.numberOfElements());
        Iterator it = slice.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        NaturalNumber number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)79L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)8L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)true, (Object)number.isOdd());
        Assertions.assertEquals((Short)7, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)73L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)71L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)67L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)61L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)7L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)true, (Object)number.isOdd());
        Assertions.assertEquals((Short)6, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="133", strategy="Use a repository method existsByIdGreaterThan confirming the correct boolean is returned.")
    public void testGreaterThanEqualExists() {
        Assertions.assertEquals((Object)true, (Object)this.positives.existsByIdGreaterThan(0L));
        Assertions.assertEquals((Object)true, (Object)this.positives.existsByIdGreaterThan(99L));
        Assertions.assertEquals((Object)false, (Object)this.positives.existsByIdGreaterThan(100L));
    }

    @Assertion(id="133", strategy="Use a repository method with the In keyword.")
    public void testIn() {
        Stream<NaturalNumber> nonPrimes = this.positives.findByNumTypeInOrderByIdAsc(Set.of(NaturalNumber.NumberType.COMPOSITE, NaturalNumber.NumberType.ONE), Limit.of((int)9));
        Assertions.assertEquals(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(6L), Long.valueOf(8L), Long.valueOf(9L), Long.valueOf(10L), Long.valueOf(12L), Long.valueOf(14L), Long.valueOf(15L)), nonPrimes.map(NaturalNumber::getId).collect(Collectors.toList()));
        Stream<NaturalNumber> primes = this.positives.findByNumTypeInOrderByIdAsc(Collections.singleton(NaturalNumber.NumberType.PRIME), Limit.of((int)6));
        Assertions.assertEquals(List.of(Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(5L), Long.valueOf(7L), Long.valueOf(11L), Long.valueOf(13L)), primes.map(NaturalNumber::getId).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method with the IgnoreCase keyword.")
    public void testIgnoreCase() {
        Stream<AsciiCharacter> found = this.characters.findByHexadecimalIgnoreCaseBetweenAndHexadecimalNotIn("4c", "5A", Set.of("5"), Sort.asc((String)"hexadecimal"));
        Assertions.assertEquals(List.of(Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')), found.map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Request a KeysetAwarePage of 7 results after the keyset of the 20th result, expecting to find the next 7 results. Then request the KeysetAwarePage before the keyset of the first entry of the page, expecting to find the previous 7 results. Then request the KeysetAwarePage after the last entry of the original slice, expecting to find the next 7.")
    public void testKeysetAwarePageOf7FromCursor() {
        KeysetAwarePage<NaturalNumber> nextPage;
        KeysetAwarePage<NaturalNumber> previousPage;
        KeysetAwarePage<NaturalNumber> page;
        Pageable middle7 = Pageable.ofSize((int)7).sortBy(new Sort[]{Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"id")}).afterKeyset(new Object[]{(short)5, 5L, 26L});
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByBitsRequiredDesc(6L, 50L, middle7);
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{25L, 8L, 15L, 14L, 13L, 12L, 11L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)7, (int)page.numberOfElements());
        try {
            previousPage = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByBitsRequiredDesc(6L, 50L, page.previousPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{16L, 31L, 30L, 29L, 28L, 27L, 26L}), (Object)Arrays.toString(previousPage.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)7, (int)previousPage.numberOfElements());
        try {
            nextPage = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByBitsRequiredDesc(6L, 50L, page.nextPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{10L, 9L, 7L, 6L, 5L, 4L, 3L, 2L}), (Object)Arrays.toString(nextPage.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)7, (int)nextPage.numberOfElements());
    }

    @Assertion(id="133", strategy="Request a KeysetAwarePage of results where none match the query, expecting an empty KeysetAwarePage with 0 results.")
    public void testKeysetAwarePageOfNothing() {
        KeysetAwarePage<NaturalNumber> page;
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByBitsRequiredDesc(1L, 4L, Pageable.ofPage((long)1L));
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((int)0, (int)page.content().size());
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
    }

    @Assertion(id="133", strategy="Request a KeysetAwareSlice of 9 results after the keyset of the 20th result, expecting to find the next 9 results. Then request the KeysetAwareSlice before the keyset of the first entry of the slice, expecting to find the previous 9 results. Then request the KeysetAwareSlice after the last entry of the original slice, expecting to find the next 9.")
    public void testKeysetAwareSliceOf9FromCursor() {
        KeysetAwareSlice<NaturalNumber> nextSlice;
        KeysetAwareSlice<NaturalNumber> previousSlice;
        KeysetAwareSlice<NaturalNumber> slice;
        Pageable middle9 = Pageable.ofSize((int)9).sortBy(new Sort[]{Sort.desc((String)"floorOfSquareRoot"), Sort.asc((String)"id")}).afterKeyset(new Object[]{6L, 46L});
        try {
            slice = this.numbers.findByNumTypeAndNumBitsRequiredLessThan(NaturalNumber.NumberType.COMPOSITE, (short)7, middle9);
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{48L, 25L, 26L, 27L, 28L, 30L, 32L, 33L, 34L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)9, (int)slice.numberOfElements());
        try {
            previousSlice = this.numbers.findByNumTypeAndNumBitsRequiredLessThan(NaturalNumber.NumberType.COMPOSITE, (short)7, slice.previousPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{63L, 36L, 38L, 39L, 40L, 42L, 44L, 45L, 46L}), (Object)Arrays.toString(previousSlice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)9, (int)previousSlice.numberOfElements());
        try {
            nextSlice = this.numbers.findByNumTypeAndNumBitsRequiredLessThan(NaturalNumber.NumberType.COMPOSITE, (short)7, slice.nextPageable());
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{35L, 16L, 18L, 20L, 21L, 22L, 24L, 9L, 10L}), (Object)Arrays.toString(nextSlice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)9, (int)nextSlice.numberOfElements());
    }

    @Assertion(id="133", strategy="Request a KeysetAwareSlice of results where none match the query, expecting an empty KeysetAwareSlice with 0 results.")
    public void testKeysetAwareSliceOfNothing() {
        KeysetAwareSlice<NaturalNumber> slice;
        Pageable pagination = Pageable.ofSize((int)33).afterKeyset(new Object[]{30L});
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(3L, pagination);
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals((Object)false, (Object)slice.hasContent());
        Assertions.assertEquals((int)0, (int)slice.content().size());
        Assertions.assertEquals((int)0, (int)slice.numberOfElements());
    }

    @Assertion(id="133", strategy="Use a repository method countByIdLessThan confirming the correct count is returned.")
    public void testLessThanWithCount() {
        Assertions.assertEquals((long)91L, (long)this.positives.countByIdLessThan(92L));
        Assertions.assertEquals((long)0L, (long)this.positives.countByIdLessThan(1L));
    }

    @Assertion(id="133", strategy="Use a repository method with both Sort and Limit, and verify that the Limit caps the number of results and that results are ordered according to the sort criteria.")
    public void testLimit() {
        Collection nums = this.numbers.findByIdGreaterThanEqual(60L, Limit.of((int)10), new Sort[]{Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"id")});
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{63L, 62L, 61L, 60L, 80L, 79L, 78L, 77L, 76L, 75L}), (Object)Arrays.toString(nums.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method with both Sort and Limit, where the Limit is a range,  and verify that the Limit range starts in the correct place, caps the number of results,  and that results are ordered according to the sort criteria.")
    public void testLimitedRange() {
        Collection nums = this.numbers.findByIdGreaterThanEqual(40L, Limit.range((long)6L, (long)10L), new Sort[]{Sort.asc((String)"numType"), Sort.asc((String)"id")});
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{61L, 67L, 71L, 73L, 79L}), (Object)Arrays.toString(nums.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method with Limit and verify that the Limit caps the number of results to the amount that is specified.")
    public void testLimitToOneResult() {
        Collection nums = this.numbers.findByIdGreaterThanEqual(80L, Limit.of((int)1), new Sort[0]);
        Iterator it = nums.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        NaturalNumber num = (NaturalNumber)it.next();
        Assertions.assertEquals((Object)true, (Object)(num.getId() >= 80L ? 1 : 0));
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="133", strategy="Use a repository method with two Sort parameters specifying a mixture of ascending and descending order, and verify all results are returned and are ordered according to the sort criteria.")
    public void testMixedSort() {
        NaturalNumber[] nums = (NaturalNumber[])this.numbers.findByIdLessThan(15L, Sort.asc((String)"numBitsRequired"), Sort.desc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{1L, 3L, 2L, 7L, 6L, 5L, 4L, 14L, 13L, 12L, 11L, 10L, 9L, 8L}), (Object)Arrays.toString(Stream.of(nums).map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method that ought to return a single entity value but where multiple results are found.Expect NonUniqueResultException.")
    public void testNonUniqueResultException() {
        try {
            AsciiCharacter ch = this.characters.findByIsControlTrueAndNumericValueBetween(10, 15);
            Assertions.fail((String)("Unexpected result of findByIsControlTrueAndNumericValueBetween(10, 15): " + ch.getHexadecimal()));
        }
        catch (NonUniqueResultException x) {
            System.out.println("testNonUniqueResultException expected to catch exception " + x + ". Printing its stack trace:");
            x.printStackTrace(System.out);
        }
    }

    @Assertion(id="133", strategy="Use a repository method with the Not keyword.")
    public void testNot() {
        NaturalNumber[] n = this.numbers.findByNumTypeNot(NaturalNumber.NumberType.COMPOSITE, Limit.of((int)8), Sort.asc((String)"id"));
        Assertions.assertEquals((int)8, (int)n.length);
        Assertions.assertEquals((long)1L, (long)n[0].getId());
        Assertions.assertEquals((long)2L, (long)n[1].getId());
        Assertions.assertEquals((long)3L, (long)n[2].getId());
        Assertions.assertEquals((long)5L, (long)n[3].getId());
        Assertions.assertEquals((long)7L, (long)n[4].getId());
        Assertions.assertEquals((long)11L, (long)n[5].getId());
        Assertions.assertEquals((long)13L, (long)n[6].getId());
        Assertions.assertEquals((long)17L, (long)n[7].getId());
    }

    @Assertion(id="133", strategy="Use a repository method with Or, expecting MappingException if the underlying database is not capable.")
    public void testOr() {
        Stream<NaturalNumber> found;
        try {
            found = this.positives.findByNumTypeOrFloorOfSquareRoot(NaturalNumber.NumberType.ONE, 2L);
        }
        catch (MappingException x) {
            return;
        }
        Assertions.assertEquals(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L)), found.map(NaturalNumber::getId).sorted().collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method with OrderBy (static) and a Sort parameter (dynamic), verfying that all results are returned and are ordered first by the static sort criteria, followed by the dynamic sort criteria when the value(s) being compared by the static criteria match.")
    public void testOrderByHasPrecedenceOverPageableSorts() {
        Pageable pagination = Pageable.ofSize((int)8).sortBy(new Sort[]{Sort.asc((String)"numType"), Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{23L, 19L, 17L, 24L, 22L, 21L, 20L, 18L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        pagination = slice.nextPageable();
        slice = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{16L, 13L, 11L, 15L, 14L, 12L, 10L, 9L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        pagination = slice.nextPageable();
        slice = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{7L, 5L, 8L, 6L, 4L, 1L, 3L, 2L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        pagination = slice.nextPageable();
        if (pagination != null) {
            slice = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination);
            Assertions.assertEquals((Object)false, (Object)slice.hasContent());
        }
    }

    @Assertion(id="133", strategy="Use a repository method with OrderBy (static) and a Pageable with a Sort parameter (dynamic), verfying that all results are returned and are ordered first by the static sort criteria, followed by the dynamic sort criteria when the value(s) being compared by the static criteria match.")
    public void testOrderByHasPrecedenceOverSorts() {
        Stream<NaturalNumber> nums = this.numbers.findByIdBetweenOrderByNumTypeAsc(5L, 24L, Sort.desc((String)"floorOfSquareRoot"), Sort.asc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{17L, 19L, 23L, 11L, 13L, 5L, 7L, 16L, 18L, 20L, 21L, 22L, 24L, 9L, 10L, 12L, 14L, 15L, 6L, 8L}), (Object)Arrays.toString(nums.map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Request a Page of results where none match the query, expecting an empty Page with 0 results.")
    public void testPageOfNothing() {
        Page<AsciiCharacter> page;
        Pageable pagination = Pageable.ofSize((int)6).sortBy(new Sort[]{Sort.asc((String)"id")});
        try {
            page = this.characters.findByNumericValueBetween(150, 160, pagination);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
        Assertions.assertEquals((long)0L, (long)page.stream().count());
        Assertions.assertEquals((int)0, (int)page.content().size());
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((Object)false, (Object)page.iterator().hasNext());
        Assertions.assertEquals((long)0L, (long)page.totalElements());
        Assertions.assertEquals((long)0L, (long)page.totalPages());
    }

    @Assertion(id="133", strategy="Use a repository method that returns a single entity value where a single result is found.")
    public void testSingleEntity() {
        AsciiCharacter ch = this.characters.findByHexadecimalIgnoreCase("2B");
        Assertions.assertEquals((char)'+', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"2b", (Object)ch.getHexadecimal());
        Assertions.assertEquals((int)43, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
    }

    @Assertion(id="133", strategy="Request a Slice of results where none match the query, expecting an empty Slice with 0 results.")
    public void testSliceOfNothing() {
        Pageable pagination = Pageable.ofSize((int)5).sortBy(new Sort[]{Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.COMPOSITE, 1L, pagination);
        Assertions.assertEquals((Object)false, (Object)slice.hasContent());
        Assertions.assertEquals((int)0, (int)slice.content().size());
        Assertions.assertEquals((int)0, (int)slice.numberOfElements());
    }

    @Assertion(id="133", strategy="Use the StaticMetamodel to obtain ascending Sorts for an entity attribute a type-safe manner.")
    public void testStaticMetamodelAscendingSorts() {
        Assertions.assertEquals((Object)Sort.asc((String)"id"), (Object)AsciiCharacter_.id.asc());
        Assertions.assertEquals((Object)Sort.asc((String)"isControl"), (Object)AsciiCharacter_.isControl.asc());
        Assertions.assertEquals((Object)Sort.ascIgnoreCase((String)"hexadecimal"), (Object)AsciiCharacter_.hexadecimal.ascIgnoreCase());
        Assertions.assertEquals((Object)Sort.ascIgnoreCase((String)"thisCharacter"), (Object)AsciiCharacter_.thisCharacter.ascIgnoreCase());
        Pageable pageRequest = Pageable.ofSize((int)6).sortBy(new Sort[]{AsciiCharacter_.numericValue.asc()});
        Page<AsciiCharacter> page1 = this.characters.findByNumericValueBetween(68, 90, pageRequest);
        Assertions.assertEquals(List.of(Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I')), page1.stream().map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use the StaticMetamodel to refer to entity attribute names in a type-safe manner.")
    public void testStaticMetamodelAttributeNames() {
        Assertions.assertEquals((Object)"hexadecimal", (Object)AsciiCharacter_.hexadecimal.name());
        Assertions.assertEquals((Object)"id", (Object)AsciiCharacter_.id.name());
        Assertions.assertEquals((Object)"isControl", (Object)AsciiCharacter_.isControl.name());
        Assertions.assertEquals((Object)"numericValue", (Object)AsciiCharacter_.numericValue.name());
        Assertions.assertEquals((Object)"thisCharacter", (Object)AsciiCharacter_.thisCharacter.name());
    }

    @Assertion(id="133", strategy="Use the StaticMetamodel to obtain descending Sorts for an entity attribute a type-safe manner.")
    public void testStaticMetamodelDescendingSorts() {
        Assertions.assertEquals((Object)Sort.desc((String)"id"), (Object)AsciiCharacter_.id.desc());
        Assertions.assertEquals((Object)Sort.desc((String)"isControl"), (Object)AsciiCharacter_.isControl.desc());
        Assertions.assertEquals((Object)Sort.descIgnoreCase((String)"hexadecimal"), (Object)AsciiCharacter_.hexadecimal.descIgnoreCase());
        Assertions.assertEquals((Object)Sort.descIgnoreCase((String)"thisCharacter"), (Object)AsciiCharacter_.thisCharacter.descIgnoreCase());
        Sort sort = AsciiCharacter_.numericValue.desc();
        AsciiCharacter[] found = this.characters.findFirst3ByNumericValueGreaterThanEqualAndHexadecimalEndsWith(30L, "1", sort);
        Assertions.assertEquals((int)3, (int)found.length);
        Assertions.assertEquals((char)'q', (char)found[0].getThisCharacter());
        Assertions.assertEquals((char)'a', (char)found[1].getThisCharacter());
        Assertions.assertEquals((char)'Q', (char)found[2].getThisCharacter());
    }

    @Assertion(id="133", strategy="Use a repository method that returns Streamable and verify the results.")
    public void testStreamable() {
        Streamable<AsciiCharacter> chars = this.characters.findByNumericValueLessThanEqualAndNumericValueGreaterThanEqual(109, 101);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Character[]{Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m')}), (Object)Arrays.toString(chars.stream().map(ch -> Character.valueOf(ch.getThisCharacter())).sorted().toArray()));
        Assertions.assertEquals((int)945, (int)chars.stream().mapToInt(AsciiCharacter::getNumericValue).sum());
        TreeSet sorted = new TreeSet();
        chars.forEach(ch -> sorted.add(ch.getHexadecimal()));
        Assertions.assertEquals(new TreeSet<String>(Set.of("65", "66", "67", "68", "69", "6a", "6b", "6c", "6d")), sorted);
        Streamable<AsciiCharacter> empty = this.characters.findByNumericValueLessThanEqualAndNumericValueGreaterThanEqual(115, 120);
        Assertions.assertEquals((Object)false, (Object)empty.iterator().hasNext());
        Assertions.assertEquals((long)0L, (long)empty.stream().count());
    }

    @Assertion(id="133", strategy="Request the third Page of 10 results, expecting to find all 10. Request the next Page via nextPageable, expecting page number 4 and another 10 results.")
    public void testThirdAndFourthPagesOf10() {
        Page<AsciiCharacter> page;
        Pageable third10 = Pageable.ofPage((long)3L).size(10).sortBy(new Sort[]{Sort.asc((String)"numericValue")});
        try {
            page = this.characters.findByNumericValueBetween(48, 90, third10);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((long)3L, (long)page.pageable().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)10, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
        Assertions.assertEquals((Object)"44:D;45:E;46:F;47:G;48:H;49:I;4a:J;4b:K;4c:L;4d:M;", (Object)page.stream().map(c -> c.getHexadecimal() + ":" + c.getThisCharacter() + ";").reduce("", String::concat));
        Pageable fourth10 = third10.next();
        page = this.characters.findByNumericValueBetween(48, 90, fourth10);
        Assertions.assertEquals((long)4L, (long)page.pageable().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)10, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
        Assertions.assertEquals((Object)"4e:N;4f:O;50:P;51:Q;52:R;53:S;54:T;55:U;56:V;57:W;", (Object)page.stream().map(c -> c.getHexadecimal() + ":" + c.getThisCharacter() + ";").reduce("", String::concat));
    }

    @Assertion(id="133", strategy="Request the third Slice of 5 results, expecting to find all 5. Request the next Slice via nextPageable, expecting page number 4 and another 5 results.")
    public void testThirdAndFourthSlicesOf5() {
        Pageable third5 = Pageable.ofPage((long)3L).size(5).sortBy(new Sort[]{Sort.desc((String)"id")});
        Slice<NaturalNumber> slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, third5);
        Assertions.assertEquals((long)3L, (long)slice.pageable().page());
        Assertions.assertEquals((int)5, (int)slice.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{37L, 31L, 29L, 23L, 19L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Pageable fourth5 = third5.next();
        slice = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, fourth5);
        Assertions.assertEquals((long)4L, (long)slice.pageable().page());
        Assertions.assertEquals((int)5, (int)slice.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{17L, 13L, 11L, 7L, 5L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method with the True keyword.")
    public void testTrue() {
        Iterable<NaturalNumber> odd = this.positives.findByIsOddTrueAndIdLessThanEqualOrderByIdDesc(10L);
        Iterator<NaturalNumber> it = odd.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)9L, (long)it.next().getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)7L, (long)it.next().getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)5L, (long)it.next().getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)3L, (long)it.next().getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)1L, (long)it.next().getId());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="133", strategy="Use a repository method with varargs Sort... specifying a mixture of ascending and descending order, and verify all results are returned and are ordered according to the sort criteria.")
    public void testVarargsSort() {
        ArrayList list = this.numbers.findByIdLessThanEqual(12L, new Sort[]{Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"numBitsRequired"), Sort.asc((String)"id")});
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{2L, 3L, 1L, 8L, 4L, 5L, 6L, 7L, 9L, 10L, 11L, 12L}), (Object)Arrays.toString(list.stream().map(number -> number.getId()).toArray()));
    }
}

