/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.metadata;

import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;

public class CollectMetaData {
    private static final String FRAMEWORK_PACKAGE_PREFIX = "ee/jakarta/tck/data/framework";
    private static final String RUNTIME_TESTS_FILE = "runtime-tests.adoc";
    private static final String CHALLENGED_TESTS_FILE = "successful-challenges.adoc";
    private static final String SIG_OUTPUT_FILE = "expected-sig-output.adoc";
    private static final String EXPECTED_OUTPUT_FILE = "expected-output.adoc";
    private static boolean debug = false;
    private static List<String> apiPackages;
    private static List<Class<?>> testClasses;
    private static File adocGeneratedLocation;

    private CollectMetaData() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new RuntimeException("CollectMetaData expected exactly 3 arguments [debug, path-to-tck, output-file-location]");
        }
        debug = Boolean.valueOf(args[0]);
        testClasses = CollectMetaData.getClassNames(args[1]);
        adocGeneratedLocation = new File(args[2]);
        if (!adocGeneratedLocation.exists()) {
            adocGeneratedLocation.mkdirs();
        }
        List<TestMetaData> testMetaData = CollectMetaData.collectMetaData(testClasses);
        CollectMetaData.writeTestCounts(testMetaData, new File(adocGeneratedLocation, RUNTIME_TESTS_FILE));
        CollectMetaData.writeSuccessfulChallenges(testMetaData, new File(adocGeneratedLocation, CHALLENGED_TESTS_FILE));
        CollectMetaData.writeSigOutput(apiPackages, new File(adocGeneratedLocation, SIG_OUTPUT_FILE));
        CollectMetaData.writeOutput(testMetaData, new File(adocGeneratedLocation, EXPECTED_OUTPUT_FILE));
        CollectMetaData.writeGitIgnore(new File(adocGeneratedLocation, ".gitignore"), RUNTIME_TESTS_FILE, CHALLENGED_TESTS_FILE, SIG_OUTPUT_FILE, EXPECTED_OUTPUT_FILE);
    }

    private static void writeGitIgnore(File outputLocation, String ... ignoredFiles) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            for (String ignoredFile : ignoredFiles) {
                writer.write(ignoredFile + System.lineSeparator());
            }
        }
    }

    private static void writeOutput(List<TestMetaData> testMetaData, File outputLocation) throws IOException {
        StringBufferWrapper expectOutputSection = new StringBufferWrapper();
        expectOutputSection.appendNewLine("[source, txt]");
        expectOutputSection.appendNewLine("----");
        expectOutputSection.appendNewLine("$ mvn clean test");
        expectOutputSection.appendNewLine("...");
        expectOutputSection.appendNewLine("[INFO] --- maven-surefire-plugin:3.0.0-M7:test (default-test) @ tck.runner ---");
        expectOutputSection.appendNewLine("[INFO] Using auto detected provider org.apache.maven.surefire.junitplatform.JUnitPlatformProvider");
        expectOutputSection.appendNewLine("[INFO]");
        expectOutputSection.appendNewLine("[INFO] -------------------------------------------------------");
        expectOutputSection.appendNewLine("[INFO]  T E S T S");
        expectOutputSection.appendNewLine("[INFO] -------------------------------------------------------");
        for (String testClass : testMetaData.stream().map(metaData -> metaData.testClass).distinct().collect(Collectors.toList())) {
            List theseTests = testMetaData.stream().filter(metaData -> metaData.testClass == testClass).collect(Collectors.toList());
            long testCount = theseTests.stream().filter(metaData -> !metaData.isDisabled).count();
            long disabledCount = theseTests.stream().filter(metaData -> metaData.isDisabled).count();
            expectOutputSection.appendNewLine("[INFO] Running " + testClass);
            if (disabledCount > 0L) {
                expectOutputSection.append("[WARNING] Tests run: " + testCount + ", Failures: 0, Errors: 0, Skipped: " + disabledCount + ",");
            } else {
                expectOutputSection.append("[INFO] Tests run: " + testCount + ", Failures: 0, Errors: 0, Skipped: " + disabledCount + ",");
            }
            expectOutputSection.appendNewLine("Time elapsed: y.yy s - in " + testClass);
            expectOutputSection.appendNewLine("[INFO]");
        }
        expectOutputSection.appendNewLine("[INFO] Results:");
        expectOutputSection.appendNewLine("[INFO]");
        long totalTestCount = testMetaData.stream().filter(metaData -> !metaData.isDisabled).count();
        long totalDisabledCount = testMetaData.stream().filter(metaData -> metaData.isDisabled).count();
        if (totalDisabledCount > 0L) {
            expectOutputSection.appendNewLine("[WARNING] Tests run: " + totalTestCount + ", Failures: 0, Errors: 0, Skipped: " + totalDisabledCount);
        } else {
            expectOutputSection.appendNewLine("[INFO] Tests run: " + totalTestCount + ", Failures: 0, Errors: 0, Skipped: " + totalDisabledCount);
        }
        expectOutputSection.appendNewLine("[INFO]");
        expectOutputSection.appendNewLine("[INFO] -------------------------------------------------------");
        expectOutputSection.appendNewLine("[INFO] BUILD SUCCESS");
        expectOutputSection.appendNewLine("[INFO] -------------------------------------------------------");
        expectOutputSection.appendNewLine("[INFO] Total time:  xx.xxx s");
        expectOutputSection.appendNewLine("[INFO] Finished at: " + LocalDateTime.now().toString());
        expectOutputSection.appendNewLine("[INFO] -------------------------------------------------------");
        expectOutputSection.append("----");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            writer.write(expectOutputSection.toString());
        }
    }

    private static void writeSigOutput(List<String> apiPackages, File outputLocation) throws IOException {
        StringBufferWrapper expectSigOutputSection = new StringBufferWrapper();
        expectSigOutputSection.appendNewLine("[source, txt]");
        expectSigOutputSection.appendNewLine("----");
        expectSigOutputSection.appendNewLine("******************************************************");
        expectSigOutputSection.appendNewLine("All package signatures passed.");
        expectSigOutputSection.appendNewLine("\tPassed packages listed below:");
        for (String apiPackage : apiPackages) {
            expectSigOutputSection.appendNewLine("\t\t" + apiPackage + "(static mode)");
            expectSigOutputSection.appendNewLine("\t\t" + apiPackage + "(reflection mode)");
        }
        expectSigOutputSection.appendNewLine("******************************************************");
        expectSigOutputSection.appendNewLine("----");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            writer.write(expectSigOutputSection.toString());
        }
    }

    private static void writeSuccessfulChallenges(List<TestMetaData> testMetaData, File outputLocation) throws IOException {
        StringBufferWrapper exemptTestsSection = new StringBufferWrapper();
        exemptTestsSection.appendNewLine("[cols=\"1,1,1\"]");
        exemptTestsSection.appendNewLine("|===");
        exemptTestsSection.appendNewParagraph("|Class |Method |Reason");
        testMetaData.stream().filter(TestMetaData::isDisabled).forEach(test -> {
            exemptTestsSection.appendNewLine("|" + test.testClass);
            exemptTestsSection.appendNewLine("|" + test.testName);
            exemptTestsSection.appendNewLine("|" + test.disabledText);
            exemptTestsSection.appendNewLine("");
        });
        exemptTestsSection.append("|===");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            writer.write(exemptTestsSection.toString());
        }
    }

    private static void writeTestCounts(List<TestMetaData> testMetaData, File outputLocation) throws IOException {
        List runnableTestMetaData = testMetaData.stream().filter(TestMetaData::isRunnable).collect(Collectors.toList());
        String compatabilityStatement = "* tests must be passed to successfully claim $1 compatibility.";
        StringBufferWrapper runtimeTestsSection = new StringBufferWrapper();
        runtimeTestsSection.append("* *" + runnableTestMetaData.stream().filter(TestMetaData::isStandalone).count());
        runtimeTestsSection.appendNewLine("* tests must be passed to successfully claim $1 compatibility.".replace("$1", "standalone"));
        runtimeTestsSection.append("* *" + runnableTestMetaData.stream().filter(TestMetaData::isCore).count());
        runtimeTestsSection.appendNewLine("* tests must be passed to successfully claim $1 compatibility.".replace("$1", "core"));
        runtimeTestsSection.append("* *" + runnableTestMetaData.stream().filter(TestMetaData::isWeb).count());
        runtimeTestsSection.appendNewLine("* tests must be passed to successfully claim $1 compatibility.".replace("$1", "web"));
        runtimeTestsSection.append("* *" + runnableTestMetaData.stream().filter(TestMetaData::isFull).count());
        runtimeTestsSection.appendNewParagraph("* tests must be passed to successfully claim $1 compatibility.".replace("$1", "full"));
        runtimeTestsSection.append("*Note:* This count includes the signature test, but does not include disabled tests");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation));){
            writer.write(runtimeTestsSection.toString());
        }
    }

    private static List<TestMetaData> collectMetaData(List<Class<?>> testClasses) {
        return testClasses.stream().flatMap(clazz -> AnnotationSupport.findAnnotatedMethods((Class)clazz, Assertion.class, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).stream()).map(method -> {
            TestMetaData metaData = new TestMetaData();
            metaData.testClass = method.getDeclaringClass().getCanonicalName();
            metaData.testName = method.getName();
            metaData.assertion = method.getAnnotation(Assertion.class).strategy();
            metaData.isDisabled = method.isAnnotationPresent(Disabled.class);
            metaData.disabledText = metaData.isDisabled ? method.getAnnotation(Disabled.class).value() : "";
            metaData.tags = CollectMetaData.findTags(method.getDeclaringClass());
            return metaData;
        }).collect(Collectors.toList());
    }

    private static List<String> findTags(Class<?> clazz) {
        return Arrays.stream(clazz.getAnnotations()).flatMap(anno -> Arrays.stream(anno.annotationType().getAnnotations())).flatMap(anno -> {
            if (anno instanceof Tag) {
                return Stream.of((Tag)anno);
            }
            if (anno instanceof Tags) {
                return Arrays.stream(((Tags)anno).value());
            }
            return Stream.empty();
        }).map(anno -> anno.value()).collect(Collectors.toList());
    }

    private static List<Class<?>> getClassNames(String jarLocation) throws Exception {
        ArrayList classList = new ArrayList();
        try (JarInputStream jar = new JarInputStream(new FileInputStream(jarLocation));){
            JarEntry entry = jar.getNextJarEntry();
            while (entry != null) {
                if (CollectMetaData.isTestClass(entry.getName())) {
                    CollectMetaData.debug("Attempting to load test class: " + entry.getName());
                    classList.add(CollectMetaData.getClass(entry.getName().replaceAll("/", "\\.")));
                } else if (entry.getName().contains("sig-test-pkg-list.txt")) {
                    CollectMetaData.debug("Attempting to read package list" + entry.getName());
                    apiPackages = new String(jar.readAllBytes(), StandardCharsets.UTF_8).lines().filter(line -> !line.contains("#")).filter(line -> !line.isBlank()).collect(Collectors.toList());
                    CollectMetaData.debug("apiPackages populated with: " + apiPackages.toString());
                }
                jar.closeEntry();
                entry = jar.getNextJarEntry();
            }
        }
        return classList;
    }

    private static boolean isTestClass(String entryName) {
        if (!entryName.endsWith(".class")) {
            return false;
        }
        if (entryName.contains(FRAMEWORK_PACKAGE_PREFIX)) {
            return false;
        }
        return entryName.substring(entryName.lastIndexOf("/"), entryName.lastIndexOf(".")).toLowerCase().contains("tests");
    }

    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className.substring(0, className.lastIndexOf(46)));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void debug(String message) {
        if (debug) {
            System.out.println(message);
        }
    }

    public static class StringBufferWrapper {
        private StringBuffer buf = new StringBuffer();
        private static final String nl = System.lineSeparator();

        public void append(String message) {
            this.buf.append(message);
        }

        public void appendNewLine(String message) {
            this.buf.append(message + nl);
        }

        public void appendNewParagraph(String message) {
            this.buf.append(message + nl + nl);
        }

        public String toString() {
            return this.buf.toString();
        }
    }

    public static class TestMetaData {
        private String testClass;
        private String testName;
        private String assertion;
        private boolean isDisabled;
        private String disabledText;
        private List<String> tags;

        public String toString() {
            return "TestMetaData [testName=" + this.testName + ", assertion=" + this.assertion + ", isDisabled=" + this.isDisabled + ", disabledText=" + this.disabledText + ", tags=" + this.tags + "]";
        }

        boolean isStandalone() {
            return this.tags.contains("standalone");
        }

        boolean isCore() {
            return this.tags.contains("core");
        }

        boolean isWeb() {
            return this.tags.contains("web");
        }

        boolean isFull() {
            return this.tags.contains("full");
        }

        boolean isDisabled() {
            return this.isDisabled;
        }

        boolean isRunnable() {
            return !this.isDisabled;
        }
    }
}

