/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.repository;

public final class Limit {
    private static final long DEFAULT_START_AT = 1L;
    private final int maxResults;
    private final long startAt;

    private Limit(int maxResults, long startAt) {
        this.maxResults = maxResults;
        this.startAt = startAt;
    }

    public int maxResults() {
        return this.maxResults;
    }

    public long startAt() {
        return this.startAt;
    }

    public static Limit of(int maxResults) {
        if (maxResults < 1) {
            throw new IllegalArgumentException("maxResults: " + maxResults);
        }
        return new Limit(maxResults, 1L);
    }

    public static Limit range(long startAt, long endAt) {
        if (startAt < 1L) {
            throw new IllegalArgumentException("startAt: " + startAt);
        }
        if (endAt < startAt) {
            throw new IllegalArgumentException("startAt: " + startAt + ", endAt: " + endAt);
        }
        if (endAt - startAt >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("startAt: " + startAt + ", endAt: " + endAt + ", maxResults > 2147483647");
        }
        return new Limit((int)(endAt - startAt + 1L), startAt);
    }
}

