/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.repository;

public final class Limit {
    private static final long DEFAULT_START_AT = 1L;
    private final long maxResults;
    private final long startAt;

    private Limit(long maxResults, long startAt) {
        this.maxResults = maxResults;
        this.startAt = startAt;
    }

    public long maxResults() {
        return this.maxResults;
    }

    public long startAt() {
        return this.startAt;
    }

    public static Limit of(long maxResults) {
        if (maxResults < 1L) {
            throw new IllegalArgumentException("maxResults: " + maxResults);
        }
        return new Limit(maxResults, 1L);
    }

    public static Limit range(long startAt, long endAt) {
        if (startAt < 1L) {
            throw new IllegalArgumentException("startAt: " + startAt);
        }
        if (endAt < startAt) {
            throw new IllegalArgumentException("startAt: " + startAt + ", endAt: " + endAt);
        }
        return new Limit(endAt - startAt + 1L, startAt);
    }
}

