/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import jakarta.data.Sort;
import jakarta.data.page.KeysetCursor;
import jakarta.data.page.Pageable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

record Pagination(long page, int size, List<Sort> sorts, Pageable.Mode mode, Pageable.Cursor cursor) implements Pageable
{
    Pagination {
        if (page < 1L) {
            throw new IllegalArgumentException("pageNumber: " + page);
        }
        if (size < 1) {
            throw new IllegalArgumentException("maxPageSize: " + size);
        }
        if (mode != Pageable.Mode.OFFSET && (cursor == null || cursor.size() == 0)) {
            throw new IllegalArgumentException("No keyset values were provided.");
        }
    }

    @Override
    public Pageable afterKeyset(Object ... keyset) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_NEXT, new KeysetCursor(keyset));
    }

    @Override
    public Pageable beforeKeyset(Object ... keyset) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_PREVIOUS, new KeysetCursor(keyset));
    }

    @Override
    public Pageable afterKeysetCursor(Pageable.Cursor keysetCursor) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_NEXT, keysetCursor);
    }

    @Override
    public Pageable beforeKeysetCursor(Pageable.Cursor keysetCursor) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_PREVIOUS, keysetCursor);
    }

    @Override
    public Pageable next() {
        if (this.mode == Pageable.Mode.OFFSET) {
            return new Pagination(this.page + 1L, this.size, this.sorts, Pageable.Mode.OFFSET, null);
        }
        throw new UnsupportedOperationException("Not supported for keyset pagination. Instead use afterKeyset or afterKeysetCursor to provide the next keyset values or obtain the nextPageable from a KeysetAwareSlice.");
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.mode == Pageable.Mode.OFFSET ? 100 : 150).append("Pageable{page=").append(this.page).append(", size=").append(this.size);
        if (this.cursor != null) {
            s.append(", mode=").append((Object)this.mode).append(", ").append(this.cursor.size()).append(" keys");
        }
        for (Sort sort : this.sorts) {
            s.append(", ").append(sort.property());
            if (sort.ignoreCase()) {
                s.append(" IGNORE CASE");
            }
            s.append(sort.isAscending() ? " ASC" : " DESC");
        }
        return s.append("}").toString();
    }

    @Override
    public Pageable page(long pageNumber) {
        return new Pagination(pageNumber, this.size, this.sorts, this.mode, this.cursor);
    }

    @Override
    public Pageable size(int maxPageSize) {
        return new Pagination(this.page, maxPageSize, this.sorts, this.mode, this.cursor);
    }

    @Override
    public Pageable sortBy(Iterable<Sort> sorts) {
        List<Sort> sortList = sorts == null ? Collections.emptyList() : StreamSupport.stream(sorts.spliterator(), false).collect(Collectors.toUnmodifiableList());
        return new Pagination(this.page, this.size, sortList, this.mode, this.cursor);
    }

    @Override
    public Pageable sortBy(Sort ... sorts) {
        return new Pagination(this.page, this.size, sorts == null ? Collections.emptyList() : List.of(sorts), this.mode, this.cursor);
    }
}

