/*
 * Decompiled with CFR 0.152.
 */
package jakarta.config;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Objects;

public abstract class TypeToken<T> {
    private final Type type = TypeToken.mostSpecializedParameterizedSuperclass(this.getClass()).getActualTypeArguments()[0];

    protected TypeToken() {
    }

    public final Type type() {
        return this.type;
    }

    public final Class<?> erase() {
        return TypeToken.erase(this.type());
    }

    public int hashCode() {
        Type type = this.type();
        return type == null ? 0 : type.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TypeToken) {
            return Objects.equals(this.type(), ((TypeToken)other).type());
        }
        return false;
    }

    public String toString() {
        Type type = this.type();
        return type == null ? "null" : type.getTypeName();
    }

    private static final Class<?> erase(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeToken.erase((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return TypeToken.erase((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return TypeToken.erase((GenericArrayType)type);
        }
        if (type instanceof TypeVariable) {
            return TypeToken.erase((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return TypeToken.erase((WildcardType)type);
        }
        return null;
    }

    private static final Class<?> erase(Class<?> type) {
        return type;
    }

    private static final Class<?> erase(ParameterizedType type) {
        return TypeToken.erase(type.getRawType());
    }

    private static final Class<?> erase(GenericArrayType type) {
        Class<?> componentType = TypeToken.erase(type.getGenericComponentType());
        if (componentType == null) {
            return null;
        }
        return Array.newInstance(componentType, 0).getClass();
    }

    private static final Class<?> erase(TypeVariable<?> type) {
        Type[] bounds = type.getBounds();
        return bounds.length > 0 ? TypeToken.erase(bounds[0]) : Object.class;
    }

    private static final Class<?> erase(WildcardType type) {
        Type[] bounds = type.getUpperBounds();
        return bounds != null && bounds.length > 0 ? TypeToken.erase(bounds[0]) : Object.class;
    }

    private static final ParameterizedType mostSpecializedParameterizedSuperclass(Type type) {
        if (type == null || type == Object.class || type == TypeToken.class) {
            return null;
        }
        Class<?> erasure = TypeToken.erase(type);
        if (erasure == null || erasure == Object.class || !TypeToken.class.isAssignableFrom(erasure)) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        return TypeToken.mostSpecializedParameterizedSuperclass(erasure.getGenericSuperclass());
    }
}

