/*
 * Decompiled with CFR 0.152.
 */
package jakarta.config;

import jakarta.config.NoSuchObjectException;
import jakarta.config.TypeToken;
import java.util.ServiceLoader;

public interface Loader {
    public <T> T load(Class<T> var1);

    public <T> T load(TypeToken<T> var1);

    public Loader path(String var1);

    public static Loader bootstrap() {
        return Loader.bootstrap(Thread.currentThread().getContextClassLoader());
    }

    public static Loader bootstrap(ClassLoader classLoader) {
        Loader loader = ServiceLoader.load(Loader.class, classLoader).findFirst().orElseThrow(NoSuchObjectException::new);
        try {
            return loader.load(Loader.class);
        }
        catch (NoSuchObjectException absentValueException) {
            System.getLogger(Loader.class.getName()).log(System.Logger.Level.DEBUG, absentValueException::getMessage, (Throwable)absentValueException);
            return loader;
        }
    }
}

