/*
 * Decompiled with CFR 0.152.
 */
package its_meow.claimit.api.claim;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import its_meow.claimit.api.ClaimItAPI;
import its_meow.claimit.api.claim.ClaimArea;
import its_meow.claimit.api.event.claim.ClaimAddedEvent;
import its_meow.claimit.api.event.claim.ClaimCreatedEvent;
import its_meow.claimit.api.event.claim.ClaimRemovedEvent;
import its_meow.claimit.api.event.claim.ClaimsClearedEvent;
import its_meow.claimit.api.event.claim.serialization.ClaimDeserializationEvent;
import its_meow.claimit.api.event.claim.serialization.ClaimSerializationEvent;
import its_meow.claimit.api.serialization.ClaimSerializer;
import its_meow.claimit.api.util.objects.BiMultiMap;
import its_meow.claimit.api.util.objects.ClaimChunkUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ClaimManager {
    private static ClaimManager instance = null;
    private ArrayList<ClaimArea> claims = new ArrayList();
    private BiMultiMap<UUID, ClaimArea> ownedClaims = new BiMultiMap();
    private Map<Integer, BiMultiMap<ClaimChunkUtil.ClaimChunk, ClaimArea>> chunks = new HashMap<Integer, BiMultiMap<ClaimChunkUtil.ClaimChunk, ClaimArea>>();

    protected ClaimManager() {
    }

    public static ClaimManager getManager() {
        if (instance == null) {
            instance = new ClaimManager();
        }
        return instance;
    }

    public boolean deleteClaim(ClaimArea claim) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new ClaimRemovedEvent(claim)) && this.claims.remove(claim)) {
            if (this.chunks.containsKey(claim.getDimensionID())) {
                this.chunks.get(claim.getDimensionID()).removeValueFromAll(claim);
            }
            this.ownedClaims.removeValueFromAll(claim);
            return true;
        }
        return false;
    }

    public final ImmutableList<ClaimArea> getClaimsList() {
        return ImmutableList.copyOf(this.claims);
    }

    @Nullable
    public ClaimArea getClaimAtLocation(World world, BlockPos pos) {
        if (this.claims.size() == 0) {
            return null;
        }
        ClaimChunkUtil.ClaimChunk chunk = ClaimChunkUtil.getChunk(pos);
        int dimID = world.provider.getDimension();
        this.chunks.putIfAbsent(dimID, new BiMultiMap());
        Set<ClaimArea> claimsInChunk = this.chunks.get(dimID).getValues(chunk);
        if (claimsInChunk != null && claimsInChunk.size() > 0) {
            for (ClaimArea claim : claimsInChunk) {
                if (claim.getWorld() != world || !claim.isBlockPosInClaim(pos)) continue;
                return claim;
            }
        } else {
            for (ClaimArea claim : this.claims) {
                if (claim.getWorld() != world || !claim.isBlockPosInClaim(pos)) continue;
                this.chunks.get(dimID).put(chunk, claim);
                return claim;
            }
        }
        return null;
    }

    @Nullable
    public ImmutableSet<ClaimArea> getClaimsInChunk(int dimensionID, ClaimChunkUtil.ClaimChunk chunk) {
        if (this.chunks.containsKey(dimensionID)) {
            return ImmutableSet.copyOf(this.chunks.get(dimensionID).getValues(chunk));
        }
        return null;
    }

    @Nullable
    public ClaimArea getClaimByNameAndOwner(String name, UUID owner) {
        for (ClaimArea claim : this.claims) {
            if (!claim.isOwner(owner) || !claim.getTrueViewName().equals(owner + "_" + name)) continue;
            return claim;
        }
        return null;
    }

    @Nullable
    public ClaimArea getClaimByTrueName(String name) {
        for (ClaimArea claim : this.claims) {
            if (!claim.getTrueViewName().equals(name)) continue;
            return claim;
        }
        return null;
    }

    public boolean isBlockInAnyClaim(World world, BlockPos pos) {
        return this.getClaimAtLocation(world, pos) != null;
    }

    public ClaimAddResult addClaim(ClaimArea claim) {
        return this.addClaim(claim, true);
    }

    public ClaimAddResult addClaimNoEvent(ClaimArea claim) {
        return this.addClaim(claim, false);
    }

    private ClaimAddResult addClaim(ClaimArea claim, boolean fireEvent) {
        if (this.claims.size() != 0) {
            for (ClaimArea claimI : this.claims) {
                BlockPos toCheck;
                int j;
                int i;
                if (claimI.getDimensionID() != claim.getDimensionID()) continue;
                for (i = 0; i <= claim.getSideLengthX(); ++i) {
                    for (j = 0; j <= claim.getSideLengthZ(); ++j) {
                        toCheck = new BlockPos(claim.getMainPosition().getX() + i, 0, claim.getMainPosition().getZ() + j);
                        if (!claimI.isBlockPosInClaim(toCheck)) continue;
                        return ClaimAddResult.OVERLAP;
                    }
                }
                for (i = 0; i <= claimI.getSideLengthX(); ++i) {
                    for (j = 0; j <= claimI.getSideLengthZ(); ++j) {
                        toCheck = new BlockPos(claimI.getMainPosition().getX() + i, 0, claimI.getMainPosition().getZ() + j);
                        if (!claim.isBlockPosInClaim(toCheck)) continue;
                        return ClaimAddResult.OVERLAP;
                    }
                }
            }
        }
        boolean doAdd = true;
        if (fireEvent) {
            ClaimCreatedEvent event = new ClaimCreatedEvent(claim);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                doAdd = false;
            }
        }
        if (doAdd) {
            this.addClaimToListInsecurely(claim);
            return ClaimAddResult.ADDED;
        }
        return ClaimAddResult.CANCELLED;
    }

    private void addClaimToListInsecurely(ClaimArea claim) {
        ClaimAddedEvent event = new ClaimAddedEvent(claim);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.claims.add(claim);
        this.ownedClaims.put(claim.getOwner(), claim);
        for (ClaimChunkUtil.ClaimChunk c : claim.getOverlappingChunks()) {
            this.chunks.putIfAbsent(claim.getDimensionID(), new BiMultiMap());
            this.chunks.get(claim.getDimensionID()).put(c, claim);
        }
    }

    public ImmutableSet<ClaimArea> getClaimsOwnedByPlayer(UUID uuid) {
        return ImmutableSet.copyOf(this.ownedClaims.getValues(uuid));
    }

    public void serialize() {
        ClaimItAPI.logger.debug("Saving claims data.");
        ClaimSerializer store = ClaimSerializer.get();
        if (store != null && store.data != null && store.data.getSize() > 0) {
            HashSet<String> toRemove = new HashSet<String>();
            for (String key : store.data.getKeySet()) {
                if (key.equals("")) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                store.data.removeTag(key);
            }
        }
        for (ClaimArea claim : this.claims) {
            String serialName = claim.getSerialName();
            NBTTagCompound data = claim.serialize();
            ClaimSerializationEvent event = new ClaimSerializationEvent(data);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) continue;
            store.data.setTag("CLAIM_" + serialName, (NBTBase)data);
            store.markDirty();
        }
    }

    public void deserialize() {
        this.clearClaims();
        ClaimSerializer store = ClaimSerializer.get();
        NBTTagCompound comp = store.data;
        if (comp != null) {
            for (String key : comp.getKeySet()) {
                ClaimItAPI.logger.debug("Loading " + key);
                ClaimArea claim = ClaimArea.deserialize(comp.getCompoundTag(key), key);
                ClaimDeserializationEvent event = new ClaimDeserializationEvent(claim);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) {
                    this.addClaimNoEvent(event.getClaim());
                    continue;
                }
                ClaimItAPI.logger.debug("Event cancelled loading of this claim.");
            }
        }
    }

    public void clearClaims() {
        MinecraftForge.EVENT_BUS.post((Event)new ClaimsClearedEvent.Pre());
        this.claims.clear();
        this.ownedClaims.clear();
        this.chunks.clear();
        MinecraftForge.EVENT_BUS.post((Event)new ClaimsClearedEvent.Post());
    }

    public static enum ClaimAddResult {
        ADDED,
        OVERLAP,
        CANCELLED;

    }
}

