/*
 * Decompiled with CFR 0.152.
 */
package its_meow.claimit.api.group;

import com.google.common.collect.ImmutableList;
import its_meow.claimit.api.claim.ClaimArea;
import its_meow.claimit.api.event.group.GroupClaimAddedEvent;
import its_meow.claimit.api.event.group.GroupClaimRemovedEvent;
import its_meow.claimit.api.permission.ClaimPermissionMember;
import its_meow.claimit.api.util.nbt.ClaimNBTUtil;
import its_meow.claimit.api.util.objects.MemberContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Group
extends MemberContainer {
    protected String name;
    protected String tag = null;
    protected Set<ClaimArea> claims = new HashSet<ClaimArea>();

    public Group(String name, UUID owner) {
        super(owner);
        this.name = name;
    }

    protected void removeMemberClaims(UUID uuid) {
        ArrayList<ClaimArea> toRemove = new ArrayList<ClaimArea>();
        this.claims.forEach(c -> {
            if (c.isOwner(uuid)) {
                toRemove.add((ClaimArea)c);
            }
        });
        toRemove.forEach(c -> this.claims.remove(c));
    }

    @Override
    public boolean removeMember(UUID uuid, ClaimPermissionMember permission) {
        boolean result = super.removeMember(uuid, permission);
        if (!this.isOwner(uuid) && this.memberLists.getKeys(uuid).size() == 0) {
            this.removeMemberClaims(uuid);
        }
        return result;
    }

    public boolean addClaim(ClaimArea claim) {
        return !MinecraftForge.EVENT_BUS.post((Event)new GroupClaimAddedEvent(this, claim)) && this.claims.add(claim);
    }

    public boolean removeClaim(ClaimArea claim) {
        return !MinecraftForge.EVENT_BUS.post((Event)new GroupClaimRemovedEvent(this, claim)) && this.claims.remove(claim);
    }

    public boolean hasClaim(ClaimArea claim) {
        return this.claims.contains(claim);
    }

    public boolean hasPermissionInClaim(EntityPlayer player, ClaimPermissionMember permission, ClaimArea claim) {
        return this.hasPermissionInClaim(player.getGameProfile().getId(), permission, claim);
    }

    public boolean hasPermissionInClaim(UUID uuid, ClaimPermissionMember permission, ClaimArea claim) {
        return this.hasClaim(claim) && this.hasPermission(uuid, permission);
    }

    @Override
    public boolean hasPermission(UUID uuid, ClaimPermissionMember permission) {
        return this.memberLists.getKeys(uuid).contains(permission) || uuid.equals(this.ownerUUID);
    }

    public ImmutableList<ClaimArea> getClaims() {
        return ImmutableList.copyOf(this.claims);
    }

    public String getName() {
        return this.name;
    }

    protected void addClaims(ArrayList<ClaimArea> claims) {
        claims.forEach(claim -> this.addClaim((ClaimArea)claim));
    }

    public NBTTagCompound serialize() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setUniqueId("owner", this.ownerUUID);
        compound.setString("name", this.name);
        compound = super.writeMembers(compound);
        compound = ClaimNBTUtil.writeClaimNames(compound, this.claims);
        if (this.tag != null) {
            compound.setString("tag", this.tag);
        }
        return compound;
    }

    public static Group deserialize(NBTTagCompound compound) {
        UUID owner = compound.getUniqueId("owner");
        String name = compound.getString("name");
        Group group = new Group(name, owner);
        group.addMembers(MemberContainer.readMembers(compound));
        group.addClaims(ClaimNBTUtil.readClaimNames(compound));
        if (compound.hasKey("tag", 8)) {
            group.setTag(compound.getString("tag"));
        }
        return group;
    }

    public void removeAllClaims() {
        this.claims.forEach(claim -> this.removeClaim((ClaimArea)claim));
    }

    public void removeAllMembers() {
        this.memberLists.getKeysToValues().forEach((key, value) -> this.memberLists.remove(key, value));
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    @Nullable
    public String getTag() {
        return this.tag;
    }
}

