/*
 * Decompiled with CFR 0.152.
 */
package its_meow.claimit.api.userconfig;

import com.google.common.collect.ImmutableMap;
import its_meow.claimit.api.userconfig.UserConfigType;
import its_meow.claimit.api.userconfig.UserConfigTypeBoolean;
import its_meow.claimit.api.userconfig.UserConfigTypeFloat;
import its_meow.claimit.api.userconfig.UserConfigTypeString;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class UserConfigTypeRegistry {
    public static final UserConfigTypeBoolean BOOLEAN = new UserConfigTypeBoolean();
    public static final UserConfigTypeString STRING = new UserConfigTypeString();
    public static final UserConfigTypeFloat FLOAT = new UserConfigTypeFloat();
    public static final Map<Class<? extends UserConfigType<?>>, UserConfigType<?>> registryMap = new HashMap();

    public static <T1, T extends UserConfigType<T1>> void addType(Class<T> typeType, T type) {
        registryMap.put(typeType, type);
    }

    @Nullable
    public static <T1, T extends UserConfigType<T1>> T getRegistry(Class<T> type) {
        if (registryMap.get(type) != null && type.isAssignableFrom(registryMap.get(type).getClass())) {
            return (T)registryMap.get(type);
        }
        return null;
    }

    public static ImmutableMap<Class<? extends UserConfigType<?>>, UserConfigType<?>> getRegistries() {
        return ImmutableMap.copyOf(registryMap);
    }

    static {
        UserConfigTypeRegistry.addType(UserConfigTypeBoolean.class, BOOLEAN);
        UserConfigTypeRegistry.addType(UserConfigTypeFloat.class, FLOAT);
        UserConfigTypeRegistry.addType(UserConfigTypeString.class, STRING);
    }
}

