/*
 * Decompiled with CFR 0.152.
 */
package its_meow.claimit.api.userconfig;

import its_meow.claimit.api.userconfig.UserConfigType;
import its_meow.claimit.api.util.nbt.NBTDeserializer;
import its_meow.claimit.api.util.nbt.NBTSerializer;

public class UserConfigTypeFloat
extends UserConfigType<Float> {
    public UserConfigTypeFloat() {
        super(Float.class);
    }

    @Override
    protected NBTSerializer<Float> getSerializer() {
        return (c, s, f) -> c.setFloat(s, ((Float)f).floatValue());
    }

    @Override
    protected NBTDeserializer<Float> getDeserializer() {
        return (c, s) -> Float.valueOf(c.getFloat(s));
    }

    @Override
    public boolean isValidValue(String in) {
        try {
            Float.parseFloat(in);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Float fromString(String valueStr) {
        return Float.valueOf(Float.parseFloat(valueStr));
    }
}

