/*
 * Decompiled with CFR 0.152.
 */
package its_meow.claimit.api.userconfig;

import com.google.common.collect.ImmutableMap;
import its_meow.claimit.api.userconfig.UserConfigValueStorage;
import its_meow.claimit.api.util.nbt.NBTDeserializer;
import its_meow.claimit.api.util.nbt.NBTSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class UserConfigType<T> {
    public final UserConfigValueStorage<T> storage = new UserConfigValueStorage();
    private final Map<String, UserConfig<T>> configs = new HashMap<String, UserConfig<T>>();
    public final Class<T> type;

    public UserConfigType(Class<T> type) {
        this.type = type;
    }

    public void addConfig(UserConfig<T> config) {
        if (this.configs.containsKey(config.parsedName)) {
            throw new RuntimeException("Identical config ID registered: " + config.parsedName);
        }
        this.configs.put(config.parsedName, config);
    }

    public final UserConfig<T> getConfig(String name) {
        return this.configs.get(name);
    }

    public String getValidConfigList() {
        String validNames = "";
        for (String name : this.configs.keySet()) {
            validNames = validNames + name + " ";
        }
        return validNames;
    }

    public void setValue(UserConfig<?> userConfig, UUID uuid, Object val) {
        this.storage.storage.values.putIfAbsent(userConfig, new UserConfigValueStorage.UserConfigTypeStorage.UserConfigUUIDValue());
        this.storage.storage.values.get(userConfig).uuids.put(uuid, this.fromString(val.toString()));
    }

    public ImmutableMap<String, UserConfig<T>> getConfigs() {
        return ImmutableMap.copyOf(this.configs);
    }

    protected abstract NBTSerializer<T> getSerializer();

    protected abstract NBTDeserializer<T> getDeserializer();

    public abstract boolean isValidValue(String var1);

    public abstract T fromString(String var1);

    public static class UserConfig<T> {
        public final String parsedName;
        public final T defaultValue;
        public final String helpInfo;

        public UserConfig(String parsedName, T defaultValue, String helpInfo) {
            this.parsedName = parsedName;
            this.defaultValue = defaultValue;
            this.helpInfo = helpInfo;
        }
    }
}

