/*
 * Decompiled with CFR 0.152.
 */
package its_meow.claimit.api.userconfig;

import its_meow.claimit.api.serialization.GlobalDataSerializer;
import its_meow.claimit.api.userconfig.UserConfigType;
import its_meow.claimit.api.userconfig.UserConfigTypeRegistry;
import its_meow.claimit.api.userconfig.UserConfigValueStorage;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class UserConfigManager {
    @Nullable
    public static <T1, T extends UserConfigType<T1>> UserConfigValueStorage<T1> getStorage(Class<T> type) {
        return ((UserConfigType)UserConfigTypeRegistry.getRegistry(type)).storage;
    }

    public static void serialize() {
        NBTTagCompound data = GlobalDataSerializer.get().data;
        NBTTagCompound configsData = new NBTTagCompound();
        for (Class clazz : UserConfigTypeRegistry.getRegistries().keySet()) {
            UserConfigType type = (UserConfigType)UserConfigTypeRegistry.getRegistries().get((Object)clazz);
            for (UserConfigType.UserConfig config : type.getConfigs().values()) {
                try {
                    type.storage.storage.values.get((Object)config).uuids.forEach((uuid, value) -> {
                        if (!configsData.hasKey(uuid.toString())) {
                            configsData.setTag(uuid.toString(), (NBTBase)new NBTTagCompound());
                        }
                        NBTTagCompound userTag = configsData.getCompoundTag(uuid.toString());
                        type.getSerializer().serialize(userTag, config.parsedName, type.type.cast(value));
                        configsData.setTag(uuid.toString(), (NBTBase)userTag);
                    });
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        data.setTag("USERCONFIG", (NBTBase)configsData);
        GlobalDataSerializer wsd = GlobalDataSerializer.get();
        wsd.markDirty();
    }

    public static void deserialize() {
        NBTTagCompound data = GlobalDataSerializer.get().data;
        NBTTagCompound configsData = data.getCompoundTag("USERCONFIG");
        for (String uuidStr : configsData.getKeySet()) {
            if (!configsData.hasKey(uuidStr, 10)) continue;
            NBTTagCompound userTag = configsData.getCompoundTag(uuidStr);
            UUID uuid = UUID.fromString(uuidStr);
            for (String parseName : userTag.getKeySet()) {
                for (Class clazz : UserConfigTypeRegistry.getRegistries().keySet()) {
                    UserConfigType type = (UserConfigType)UserConfigTypeRegistry.getRegistries().get((Object)clazz);
                    UserConfigType.UserConfig config = type.getConfig(parseName);
                    if (config == null) continue;
                    Object val = type.getDeserializer().deserialize(userTag, config.parsedName);
                    type.setValue(config, uuid, val);
                }
            }
        }
    }
}

