/*
 * Decompiled with CFR 0.152.
 */
package its_meow.claimit.api.claim;

import com.google.common.collect.ImmutableMap;
import its_meow.claimit.api.ClaimItAPI;
import its_meow.claimit.api.claim.ClaimManager;
import its_meow.claimit.api.event.claim.ClaimCheckPermissionEvent;
import its_meow.claimit.api.group.Group;
import its_meow.claimit.api.group.GroupManager;
import its_meow.claimit.api.permission.ClaimPermissionMember;
import its_meow.claimit.api.permission.ClaimPermissionRegistry;
import its_meow.claimit.api.permission.ClaimPermissionToggle;
import its_meow.claimit.api.permission.ClaimPermissions;
import its_meow.claimit.api.util.nbt.ClaimNBTUtil;
import its_meow.claimit.api.util.objects.ClaimChunkUtil;
import its_meow.claimit.api.util.objects.MemberContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;

public class ClaimArea
extends MemberContainer {
    protected int posX;
    protected int posZ;
    private final int dimID;
    protected int sideLengthX;
    protected int sideLengthZ;
    protected String viewName;
    protected Map<ClaimPermissionToggle, Boolean> toggles;

    public ClaimArea(int dimID, int posX, int posZ, int sideLengthX, int sideLengthZ, EntityPlayer player) {
        this(dimID, posX, posZ, sideLengthX, sideLengthZ, player.getGameProfile().getId());
    }

    public ClaimArea(int dimID, int posX, int posZ, int sideLengthX, int sideLengthZ, UUID ownerUUID) {
        super(ownerUUID);
        this.dimID = dimID;
        this.posX = posX;
        this.posZ = posZ;
        this.sideLengthX = sideLengthX;
        this.sideLengthZ = sideLengthZ;
        this.ownerUUID = ownerUUID;
        this.toggles = new HashMap<ClaimPermissionToggle, Boolean>();
        for (ClaimPermissionToggle perm : ClaimPermissionRegistry.getTogglePermissions()) {
            this.toggles.putIfAbsent(perm, perm.defaultValue);
        }
        if (this.sideLengthX < 0 || this.sideLengthZ < 0) {
            if (this.sideLengthX < 0) {
                this.posX += this.sideLengthX;
                this.sideLengthX = Math.abs(this.sideLengthX);
            }
            if (this.sideLengthZ < 0) {
                this.posZ += this.sideLengthZ;
                this.sideLengthZ = Math.abs(this.sideLengthZ);
            }
        }
        this.viewName = ownerUUID.toString() + "_" + Math.abs(posX) + Math.abs(posZ) + dimID + Math.round(Math.random() * 100.0);
    }

    public ClaimArea(int dimID, int posX, int posZ, int sideLengthX, int sideLengthZ, UUID ownerUUID, String trueViewName) {
        this(dimID, posX, posZ, sideLengthX, sideLengthZ, ownerUUID);
        this.viewName = trueViewName;
    }

    @Override
    public boolean isOwner(UUID owner) {
        return this.getOwner().equals(owner);
    }

    public boolean canModify(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.MODIFY);
    }

    public boolean canUse(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.USE);
    }

    public boolean canEntity(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.ENTITY);
    }

    public boolean canPVP(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.PVP);
    }

    public boolean canManage(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.MANAGE_PERMS);
    }

    @Override
    public boolean hasPermission(EntityPlayer player, ClaimPermissionMember permission) {
        ClaimCheckPermissionEvent event = new ClaimCheckPermissionEvent(this, player, permission);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (player instanceof FakePlayer) {
            return this.isPermissionToggled(ClaimPermissions.ALLOW_FAKE_PLAYER_BYPASS);
        }
        return this.isOwner(player) || this.isMemberPermissionToggled(permission) || this.memberLists.getValues(permission).contains(player.getGameProfile().getId()) || this.hasPermissionFromGroup(permission, player);
    }

    @Override
    public boolean hasPermission(UUID uuid, ClaimPermissionMember permission) {
        ClaimCheckPermissionEvent event = new ClaimCheckPermissionEvent(this, uuid, permission);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        return this.isOwner(uuid) || this.isMemberPermissionToggled(permission) || this.memberLists.getValues(permission).contains(uuid) || this.hasPermissionFromGroup(permission, uuid);
    }

    private boolean hasPermissionFromGroup(ClaimPermissionMember permission, EntityPlayer player) {
        return this.hasPermissionFromGroup(permission, player.getGameProfile().getId());
    }

    private boolean hasPermissionFromGroup(ClaimPermissionMember permission, UUID uuid) {
        for (Group group : GroupManager.getGroups()) {
            if (permission == ClaimPermissions.MANAGE_PERMS || !group.hasPermissionInClaim(uuid, permission, this)) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberPermissionToggled(ClaimPermissionMember permission) {
        ClaimPermissionToggle toggle = ClaimPermissionRegistry.getToggleFor(permission);
        return toggle != null && this.isPermissionToggled(toggle);
    }

    public boolean isPermissionToggled(ClaimPermissionToggle perm) {
        if (perm.getForceEnabled()) {
            return perm.getForceValue();
        }
        if (!this.toggles.containsKey(perm)) {
            return perm.defaultValue;
        }
        return this.toggles.get(perm);
    }

    public void flipPermissionToggle(ClaimPermissionToggle perm) {
        this.toggles.put(perm, this.toggles.get(perm) == false);
    }

    public void setPermissionToggle(ClaimPermissionToggle perm, boolean value) {
        this.toggles.put(perm, value);
    }

    public ImmutableMap<ClaimPermissionToggle, Boolean> getToggles() {
        return ImmutableMap.copyOf(this.toggles);
    }

    @Override
    public boolean inPermissionList(ClaimPermissionMember permission, UUID id) {
        Set members = this.memberLists.getValues(permission);
        return members != null && members.contains(id);
    }

    protected void setToggles(Map<ClaimPermissionToggle, Boolean> toggles) {
        toggles.forEach((p, b) -> this.toggles.put((ClaimPermissionToggle)p, (Boolean)b));
    }

    public boolean isBlockPosInClaim(BlockPos blockPos) {
        boolean isInXRange = blockPos.getX() < this.getHXZPosition().getX() + 1 && blockPos.getX() > this.posX - 1;
        boolean isInZRange = blockPos.getZ() < this.getHXZPosition().getZ() + 1 && blockPos.getZ() > this.posZ - 1;
        return isInXRange && isInZRange;
    }

    public BlockPos getMainPosition() {
        return new BlockPos(this.posX, 0, this.posZ);
    }

    public BlockPos getHXZPosition() {
        return new BlockPos(this.posX + this.sideLengthX, 0, this.posZ + this.sideLengthZ);
    }

    public BlockPos getHXLZPosition() {
        return new BlockPos(this.posX + this.sideLengthX, 0, this.posZ);
    }

    public BlockPos getLXHZPosition() {
        return new BlockPos(this.posX, 0, this.posZ + this.sideLengthZ);
    }

    public BlockPos[] getTwoMainClaimCorners() {
        BlockPos[] corners = new BlockPos[]{this.getMainPosition(), this.getHXZPosition()};
        return corners;
    }

    public BlockPos[] getFourCorners() {
        BlockPos[] corners = new BlockPos[]{this.getMainPosition(), this.getHXLZPosition(), this.getLXHZPosition(), this.getHXZPosition()};
        return corners;
    }

    public int getSideLengthX() {
        return this.sideLengthX;
    }

    public int getSideLengthZ() {
        return this.sideLengthZ;
    }

    public int getDimensionID() {
        return this.dimID;
    }

    public World getWorld() {
        return DimensionManager.getWorld((int)this.dimID);
    }

    public int getArea() {
        return (this.sideLengthX + 1) * (this.sideLengthZ + 1);
    }

    public int[] getSelfAsInt() {
        int[] s = new int[]{0, this.dimID, this.posX, this.posZ, this.sideLengthX, this.sideLengthZ};
        return s;
    }

    public String getTrueViewName() {
        return this.viewName;
    }

    public String getDisplayedViewName() {
        if (!this.viewName.contains("_")) {
            this.viewName = this.ownerUUID.toString() + "_" + Math.abs(this.posX) + Math.abs(this.posZ) + this.dimID + Math.round(Math.random() * 100.0);
        }
        return this.viewName.substring(this.viewName.indexOf(95) + 1);
    }

    public boolean setViewName(String nameIn) {
        boolean pass = true;
        for (ClaimArea claim : ClaimManager.getManager().getClaimsOwnedByPlayer(this.getOwner())) {
            if (!claim.getTrueViewName().equals(this.ownerUUID + "_" + nameIn) || claim == this) continue;
            pass = false;
        }
        if (pass) {
            this.viewName = this.ownerUUID + "_" + nameIn;
        }
        return pass;
    }

    public Set<ClaimChunkUtil.ClaimChunk> getOverlappingChunks() {
        HashSet<ClaimChunkUtil.ClaimChunk> chunks = new HashSet<ClaimChunkUtil.ClaimChunk>();
        ClaimChunkUtil.ClaimChunk hChunk = ClaimChunkUtil.getChunk(this.getHXZPosition());
        ClaimChunkUtil.ClaimChunk lChunk = ClaimChunkUtil.getChunk(this.getMainPosition());
        for (int x = lChunk.x; x <= hChunk.x; ++x) {
            for (int z = lChunk.z; z <= hChunk.z; ++z) {
                chunks.add(new ClaimChunkUtil.ClaimChunk(x, z));
            }
        }
        return chunks;
    }

    public NBTTagCompound serialize() {
        int[] claimVals = this.getSelfAsInt();
        UUID owner = this.getOwner();
        NBTTagCompound data = new NBTTagCompound();
        data.setIntArray("CLAIMINFO", claimVals);
        data.setString("OWNERUID", owner.toString());
        data.setString("TRUEVIEWNAME", this.getTrueViewName());
        data = super.writeMembers(data);
        data = ClaimNBTUtil.writeToggles(data, this.getToggles());
        return data;
    }

    public static ClaimArea deserialize(NBTTagCompound tag, String keyName) {
        int[] claimVals = tag.getIntArray("CLAIMINFO");
        UUID owner = UUID.fromString(tag.getString("OWNERUID"));
        String trueViewName = tag.getString("TRUEVIEWNAME");
        if (trueViewName == null || trueViewName.equals("")) {
            trueViewName = keyName;
        }
        if (claimVals.length > 0 && claimVals[0] == 0) {
            ClaimItAPI.logger.debug("Valid version.");
            ClaimArea claim = new ClaimArea(claimVals[1], claimVals[2], claimVals[3], claimVals[4], claimVals[5], owner, trueViewName);
            claim.addMembers(MemberContainer.readMembers(tag));
            claim.setToggles(ClaimNBTUtil.readToggles(tag));
            return claim;
        }
        ClaimItAPI.logger.log(Level.FATAL, "Detected version that doesn't exist yet! Mod was downgraded? Claim cannot be loaded.");
        throw new RuntimeException("Canceled loading to prevent loss of claim data. If you recently downgraded versions, please upgrade or contact author.");
    }

    public int hashCode() {
        return Objects.hash(this.dimID, this.posX, this.posZ, this.ownerUUID, this.sideLengthX, this.sideLengthZ);
    }
}

