/*
 * Decompiled with CFR 0.152.
 */
package its_meow.claimit.api;

import its_meow.claimit.api.claim.ClaimManager;
import its_meow.claimit.api.config.ClaimItAPIConfig;
import its_meow.claimit.api.group.GroupManager;
import its_meow.claimit.api.permission.ClaimPermissions;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="claimitapi")
@Mod(modid="claimitapi", name="ClaimIt API", version="1.12.2-1.0.1", acceptedMinecraftVersions="[1.12,1.12.2]", acceptableRemoteVersions="*")
public class ClaimItAPI {
    public static final String MOD_ID = "claimitapi";
    public static final String VERSION = "1.12.2-1.0.1";
    public static final String NAME = "ClaimIt API";
    public static final String acceptedMCV = "[1.12,1.12.2]";
    @Mod.Instance(value="claimitapi")
    public static ClaimItAPI mod;
    public static Configuration config;
    public static final Logger logger;

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        ClaimManager.getManager().deserialize();
        GroupManager.deserialize();
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent event) {
        ClaimManager.getManager().serialize();
        GroupManager.serialize();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ClaimPermissions.register();
        File directory = event.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "claimit_api.cfg"));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        ClaimItAPIConfig.readConfig(config);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save e) {
        if (!e.getWorld().isRemote) {
            ClaimManager.getManager().serialize();
            GroupManager.serialize();
        }
    }

    static {
        logger = LogManager.getLogger((String)MOD_ID);
    }
}

